/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.client.gui;

import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.client.gui.GuiBitToolSettingsMenu;
import com.phylogeny.extrabitmanipulation.helper.BitToolSettingsHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public abstract class SliderSetting {
    private GuiBitToolSettingsMenu.GuiSliderSetting slider;
    private GuiButton plus;
    private GuiButton minus;

    public int getMaxValue() {
        return 0;
    }

    public GuiBitToolSettingsMenu.GuiSliderSetting getSlider() {
        return this.slider;
    }

    public void createElements(GuiBitToolSettingsMenu.GuiSliderSetting slider) {
        this.slider = slider;
        this.plus = this.createIncrementButton(slider, -1, "+");
        this.minus = this.createIncrementButton(slider, 1, "-");
    }

    private GuiButton createIncrementButton(GuiBitToolSettingsMenu.GuiSliderSetting slider, int offsetX, String text) {
        return new GuiButtonExt(slider.field_146127_k * 100, slider.field_146128_h - (offsetX > 0 ? slider.field_146121_g : -slider.field_146120_f) + offsetX, slider.field_146129_i, slider.field_146121_g, slider.field_146121_g, text);
    }

    public void addAllElements(List<GuiButton> buttonList) {
        buttonList.add((GuiButton)this.slider);
        buttonList.add(this.plus);
        buttonList.add(this.minus);
    }

    public void increment(GuiButton button) {
        boolean add;
        boolean bl = add = button == this.plus;
        if (!add && button != this.minus) {
            return;
        }
        int value = this.getValue();
        if (add ? value < this.getMaxValue() : value > 0) {
            this.slider.setValue(value + (add ? 1 : -1));
            this.slider.updateSlider();
        }
    }

    protected int getValue() {
        return 0;
    }

    protected abstract void setValue(EntityPlayer var1, int var2);

    public void setValueIfDiffrent() {
        int value = this.slider.getValueInt();
        if (value != this.getValue()) {
            this.setValue(ClientHelper.getPlayer(), value);
        }
    }

    protected NBTTagCompound getHeldStackNBT() {
        return ItemStackHelper.getNBTOrNew(ClientHelper.getHeldItemMainhand());
    }

    public static class WallThickness
    extends SliderSetting {
        @Override
        public int getMaxValue() {
            return Configs.maxWallThickness;
        }

        @Override
        protected int getValue() {
            return BitToolSettingsHelper.getWallThickness(this.getHeldStackNBT());
        }

        @Override
        protected void setValue(EntityPlayer player, int value) {
            BitToolSettingsHelper.setWallThickness(player, player.func_184614_ca(), value, Configs.sculptWallThickness);
        }
    }

    public static class SemiDiameter
    extends SliderSetting {
        @Override
        public int getMaxValue() {
            return Configs.maxSemiDiameter;
        }

        @Override
        protected int getValue() {
            return BitToolSettingsHelper.getSemiDiameter(this.getHeldStackNBT());
        }

        @Override
        protected void setValue(EntityPlayer player, int value) {
            BitToolSettingsHelper.setSemiDiameter(player, player.func_184614_ca(), value, Configs.sculptSemiDiameter);
        }
    }
}

