/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.client.gui;

import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.api.ChiselsAndBitsAPIAccess;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.client.gui.GuiBitMapping;
import com.phylogeny.extrabitmanipulation.client.gui.GuiListBitMapping;
import com.phylogeny.extrabitmanipulation.client.render.RenderState;
import com.phylogeny.extrabitmanipulation.helper.BitIOHelper;
import com.phylogeny.extrabitmanipulation.helper.BitInventoryHelper;
import com.phylogeny.extrabitmanipulation.item.ItemModelingTool;
import com.phylogeny.extrabitmanipulation.packet.PacketCursorStack;
import java.util.ArrayList;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiListBitMappingEntry
implements GuiListExtended.IGuiListEntry {
    private final Minecraft mc;
    private final GuiBitMapping bitMappingScreen;
    private IBlockState state;
    private ArrayList<ItemModelingTool.BitCount> bitCountArray;
    private boolean isManuallyMapped;
    private boolean isInteractive;
    private int frameCounter;

    public GuiListBitMappingEntry(GuiListBitMapping listBitMapping, IBlockState state, ArrayList<ItemModelingTool.BitCount> bitCountArray, boolean isManuallyMapped, boolean isInteractive) {
        this.bitMappingScreen = listBitMapping.getGuiModelingTool();
        this.mc = this.bitMappingScreen.field_146297_k;
        this.state = state;
        this.bitCountArray = bitCountArray;
        this.isManuallyMapped = isManuallyMapped;
        this.isInteractive = isInteractive;
    }

    public boolean isInteractive() {
        return this.isInteractive;
    }

    public IBlockState getState() {
        return this.state;
    }

    private ItemModelingTool.BitCount getBitCountObject() {
        if (this.bitCountArray.isEmpty()) {
            return null;
        }
        return this.bitCountArray.get(this.frameCounter % (this.bitCountArray.size() * 120) / 120);
    }

    public ArrayList<ItemModelingTool.BitCount> getBitCountArray() {
        return this.bitCountArray;
    }

    private IBitBrush getBit() {
        ItemModelingTool.BitCount bitCount = this.getBitCountObject();
        if (bitCount == null) {
            return null;
        }
        return bitCount.getBit();
    }

    public ItemStack getBitStack() {
        IBitBrush bit = this.getBit();
        return bit == null ? ItemStack.field_190927_a : bit.getItemStack(1);
    }

    public boolean isAir() {
        IBitBrush bit = this.getBit();
        return bit != null && bit.isAir();
    }

    public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        ++this.frameCounter;
        x -= 43;
        int guiTop = this.bitMappingScreen.getGuiTop();
        if (--y > guiTop && y < guiTop + 125) {
            if (this.isManuallyMapped) {
                GuiBitMapping.func_73734_a((int)x, (int)(y - 1), (int)(x + listWidth), (int)(y + slotHeight + 1), (int)2110310655);
                GlStateManager.func_179147_l();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ClientHelper.bindTexture(GuiBitMapping.GUI_TEXTURE);
            this.bitMappingScreen.func_73729_b(x, y, 0, 219, listWidth, slotHeight);
            RenderHelper.func_74520_c();
            if (!this.getBitStack().func_190926_b()) {
                this.mc.func_175599_af().func_175042_a(this.getBitStack(), x + 44, y + 2);
            } else if (this.getBit() == null) {
                this.drawCross(x, y);
            }
            RenderState.renderStateIntoGUI(this.state, x, y);
            RenderHelper.func_74518_a();
        }
    }

    private void drawCross(int x, int y) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        GL11.glLineWidth((float)(scaledresolution.func_78325_e() * 2));
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        int x2 = x + 44;
        int y2 = y + 2;
        int x3 = x2 + 16;
        int y3 = y2 + 16;
        buffer.func_181662_b((double)x2, (double)y2, 0.0).func_181669_b(255, 0, 0, 255).func_181675_d();
        buffer.func_181662_b((double)x3, (double)y3, 0.0).func_181669_b(255, 0, 0, 255).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)x3, (double)y2, 0.0).func_181669_b(255, 0, 0, 255).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y3, 0.0).func_181669_b(255, 0, 0, 255).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bitMappingScreen.func_73729_b(--x2, --y2, 43, 220, 18, 1);
        this.bitMappingScreen.func_73729_b(x2, y2 + 17, 43, 237, 18, 1);
    }

    public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        boolean bitSlotClicked;
        ItemStack cursorStack = this.mc.field_71439_g.field_71071_by.func_70445_o();
        boolean inSlotVerticalRange = relativeY >= 0 && relativeY < 18;
        boolean stateSlotClicked = relativeX > -39 && relativeX < -20 && inSlotVerticalRange;
        boolean bl = bitSlotClicked = relativeX >= 0 && relativeX < 18 && inSlotVerticalRange;
        if (cursorStack.func_190926_b() && mouseEvent == 2 && this.mc.field_71439_g.field_71075_bZ.field_75098_d && (stateSlotClicked || bitSlotClicked)) {
            Item item;
            ItemStack stack = ItemStack.field_190927_a;
            if (stateSlotClicked && (item = Item.func_150898_a((Block)this.state.func_177230_c())) != Items.field_190931_a && item instanceof ItemBlock) {
                stack = new ItemStack(item, 64, item.func_77614_k() ? this.state.func_177230_c().func_176201_c(this.state) : 0);
                stack.func_190920_e(stack.func_77976_d());
            }
            if (bitSlotClicked && !this.getBitStack().func_190926_b()) {
                stack = this.getBitStack().func_77946_l();
                stack.func_190920_e(stack.func_77976_d());
            }
            if (!stack.func_190926_b()) {
                this.mc.field_71439_g.field_71071_by.func_70437_b(stack);
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketCursorStack(stack));
            }
        }
        if (!this.isInteractive || !bitSlotClicked || this.bitCountArray.size() != 1) {
            return false;
        }
        IBitBrush bit = this.bitCountArray.get(0).getBit();
        IChiselAndBitsAPI api = ChiselsAndBitsAPIAccess.apiInstance;
        boolean changed = false;
        if (!cursorStack.func_190926_b()) {
            Block block;
            if (BitInventoryHelper.isBitStack(api, cursorStack)) {
                try {
                    bit = api.createBrush(cursorStack);
                    changed = true;
                }
                catch (APIExceptions.InvalidBitItem invalidBitItem) {}
            } else if (cursorStack.func_77973_b() != null && (block = Block.func_149634_a((Item)cursorStack.func_77973_b())) != Blocks.field_150350_a) {
                try {
                    bit = api.createBrushFromState(BitIOHelper.getStateFromMeta(block, cursorStack.func_77960_j()));
                    changed = true;
                }
                catch (APIExceptions.InvalidBitItem invalidBitItem) {}
            }
        } else if (GuiScreen.func_146271_m()) {
            bit = null;
            changed = true;
        } else if (GuiScreen.func_146272_n()) {
            try {
                bit = api.createBrushFromState(null);
                changed = true;
            }
            catch (APIExceptions.InvalidBitItem invalidBitItem) {
                // empty catch block
            }
        }
        if (changed) {
            this.bitCountArray.get(0).setBit(bit);
            this.bitMappingScreen.addPermanentMapping(this.state, bit);
        }
        return changed;
    }

    public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
    }

    public void func_192633_a(int entryID, int insideLeft, int yPos, float partialTicks) {
    }
}

