/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.client.gui;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.client.gui.ButtonsSetting;
import com.phylogeny.extrabitmanipulation.client.gui.SliderSetting;
import com.phylogeny.extrabitmanipulation.client.gui.button.GuiButtonBase;
import com.phylogeny.extrabitmanipulation.client.gui.button.GuiButtonSelect;
import com.phylogeny.extrabitmanipulation.helper.BitToolSettingsHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.item.ItemBitWrench;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.item.ItemModelingTool;
import com.phylogeny.extrabitmanipulation.item.ItemSculptingTool;
import com.phylogeny.extrabitmanipulation.shape.Shape;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.input.Keyboard;

public class GuiBitToolSettingsMenu
extends GuiScreen
implements GuiSlider.ISlider {
    private List<ButtonsSetting> buttonsSettingList = Lists.newArrayList();
    private List<SliderSetting> sliderSettingList = Lists.newArrayList();
    private int buttonCount;
    private int lineCount;
    private boolean closing;
    private float visibility;
    private Stopwatch timer = Stopwatch.createStarted();

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        ItemStack stack = ClientHelper.getHeldItemMainhand();
        if (stack.func_190926_b()) {
            return;
        }
        if (ItemStackHelper.isBitWrenchStack(stack)) {
            this.lineCount = 1;
            this.addButtonsSettings(new ButtonsSetting.WrenchMode(), "Mode", ItemBitWrench.MODE_TEXT);
        } else if (ItemStackHelper.isModelingToolStack(stack)) {
            this.lineCount = 3;
            this.addButtonsSettings(new ButtonsSetting.ModelAreaMode(), "Area Mode", ItemModelingTool.AREA_MODE_TITLES);
            String[] snapTexts = ItemModelingTool.SNAP_MODE_TITLES;
            String[] snapTextsNew = new String[snapTexts.length];
            for (int i = 0; i < snapTexts.length; ++i) {
                snapTextsNew[i] = snapTexts[i].replace("Snap-to-Chunk ", "");
            }
            this.addButtonsSettings(new ButtonsSetting.ModelSnapMode(), "Chunk Snap", snapTextsNew);
            this.addButtonsSettings(new ButtonsSetting.ModelGuiOpen(), "Open GUI", "On Read", "Off");
        } else if (ItemStackHelper.isSculptingToolStack(stack)) {
            String[] stringArray;
            this.lineCount = 8;
            ItemSculptingTool sculptingTool = (ItemSculptingTool)stack.func_77973_b();
            if (!sculptingTool.removeBits()) {
                ++this.lineCount;
            }
            this.addButtonsSettings(new ButtonsSetting.SculptMode(), "Mode", ItemSculptingTool.MODE_TITLES);
            if (sculptingTool.isCurved()) {
                stringArray = Arrays.copyOfRange(Shape.SHAPE_NAMES, 0, 3);
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = Shape.SHAPE_NAMES[3];
                stringArray = stringArray2;
                stringArray2[1] = Shape.SHAPE_NAMES[6];
            }
            String[] texts = stringArray;
            this.addButtonsSettings(new ButtonsSetting.ShapeType(), "Shape", texts);
            this.addButtonsSettings(new ButtonsSetting.Direction(), "Direction", BitToolSettingsHelper.getDirectionNames());
            this.addButtonsSettings(new ButtonsSetting.BitGridTargeted(), "Target", "Bits", "Bit Grid");
            this.addButtonsSettings(new ButtonsSetting.HollowShape(), "Interior", "Hollow", "Solid");
            this.addButtonsSettings(new ButtonsSetting.OpenEnds(), "Ends", "Open", "Closed");
            if (!sculptingTool.removeBits()) {
                this.addButtonsSettings(new ButtonsSetting.OffsetShape(), "Shape Placement", "Offset", "Centered");
            }
            this.addSliderSetting(new SliderSetting.SemiDiameter(), "Semi Diameter");
            this.addSliderSetting(new SliderSetting.WallThickness(), "Wall Thickness");
        } else if (ItemStackHelper.isChiseledArmorStack(stack)) {
            this.lineCount = 4;
            this.addButtonsSettings(new ButtonsSetting.ArmorMode(), "Mode", ItemChiseledArmor.MODE_TITLES);
            this.addButtonsSettings(new ButtonsSetting.ArmorScale(), "Scale", ItemChiseledArmor.SCALE_TITLES);
            this.addButtonsSettings(new ButtonsSetting.ArmorGridTarget(), "Collection Grid", "Blocks", "Bits");
            this.addButtonsSettings(new ButtonsSetting.ArmorMovingPart(), "Moving Part", ((ItemChiseledArmor)stack.func_77973_b()).MOVING_PART_TITLES);
        }
    }

    protected void addSliderSetting(SliderSetting sliderSetting, String title) {
        int x = this.getX();
        int y = this.getY();
        this.createLabel(title, x, y);
        GuiSliderSetting slider = new GuiSliderSetting(this.buttonCount++, x + 13, y - 1, " Bits", sliderSetting.getMaxValue(), sliderSetting.getValue(), this);
        sliderSetting.createElements(slider);
        sliderSetting.addAllElements(this.field_146292_n);
        this.sliderSettingList.add(sliderSetting);
        this.lineCount -= 2;
    }

    private void addButtonsSettings(ButtonsSetting buttons, String title, String ... buttonTexts) {
        int x = this.getX();
        int y = this.getY();
        this.createLabel(title, x, y);
        for (int i = 0; i < buttonTexts.length; ++i) {
            int buttonWidth = this.field_146289_q.func_78256_a(buttonTexts[i]) + 6;
            buttons.addButton(new GuiButtonSetting(this.buttonCount++, x, y, buttonWidth, buttonTexts[i]));
            x += buttonWidth + 4;
        }
        buttons.initButtons();
        this.field_146292_n.addAll(buttons.getButtons());
        this.buttonsSettingList.add(buttons);
    }

    protected void createLabel(String title, int x, int y) {
        GuiLabel label = new GuiLabel(this.field_146289_q, this.buttonCount, x - this.field_146289_q.func_78256_a(title) - 10, y + 1, this.field_146294_l, 13, -1);
        label.func_175202_a(title + "");
        this.field_146293_o.add(label);
    }

    private int getX() {
        return this.field_146294_l / 2 + 5;
    }

    private int getY() {
        return this.field_146295_m / 2 - this.lineCount * 10 + this.buttonsSettingList.size() * 20 + 4;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.timer == null) {
            this.timer = Stopwatch.createStarted();
        }
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, (int)(this.visibility * 98.0f) << 24, (int)(this.visibility * 128.0f) << 24);
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((GuiScreen)this));
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.visibility = Math.min((float)this.timer.elapsed(TimeUnit.MILLISECONDS) * 0.01f, 1.0f);
        if (this.closing) {
            this.visibility = 1.0f - this.visibility;
        }
        if (this.visibility == 0.0f) {
            for (SliderSetting sliderSetting : this.sliderSettingList) {
                sliderSetting.getSlider().func_146116_c(this.field_146297_k, mouseX, mouseY);
            }
            this.setToolValuesIfDiffrent();
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void func_146282_l() throws IOException {
        if (!Keyboard.getEventKeyState()) {
            this.closing = !Keyboard.getEventKeyState();
            this.timer = Stopwatch.createStarted();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.setToolValuesIfDiffrent();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        for (ButtonsSetting buttonsSetting : this.buttonsSettingList) {
            for (int i = 0; i < buttonsSetting.buttons.size(); ++i) {
                GuiButtonBase button2 = buttonsSetting.buttons.get(i);
                if (button2.field_146127_k != button.field_146127_k) continue;
                for (int i2 = 0; i2 < buttonsSetting.buttons.size(); ++i2) {
                    buttonsSetting.buttons.get((int)i2).selected = false;
                }
                button2.selected = true;
            }
        }
        for (SliderSetting sliderSetting : this.sliderSettingList) {
            sliderSetting.increment(button);
        }
    }

    private void setToolValuesIfDiffrent() {
        for (ButtonsSetting buttonsSetting : this.buttonsSettingList) {
            buttonsSetting.setValueIfDiffrent();
        }
        for (SliderSetting sliderSetting : this.sliderSettingList) {
            sliderSetting.setValueIfDiffrent();
        }
    }

    public void onChangeSliderValue(GuiSlider slider) {
        this.setToolValuesIfDiffrent();
    }

    protected class GuiSliderSetting
    extends GuiSlider {
        public GuiSliderSetting(int id, int xPos, int yPos, String suf, double maxVal, double currentVal, GuiSlider.ISlider par) {
            super(id, xPos, yPos, 100, 14, "", suf, 0.0, maxVal, currentVal, false, true, par);
        }

        protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
            if (!this.field_146125_m) {
                return;
            }
            if (this.dragging) {
                this.sliderValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                this.updateSlider();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_146122_a, (int)(this.field_146128_h + (int)(this.sliderValue * (double)(this.field_146120_f - 8))), (int)this.field_146129_i, (int)0, (int)66, (int)8, (int)this.field_146121_g, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
        }
    }

    protected class GuiButtonSetting
    extends GuiButtonSelect {
        private List<GuiButtonSetting> buttons;

        public GuiButtonSetting(int buttonId, int x, int y, int width, String text) {
            super(buttonId, x, y, width, 12, text, "", -16726016, -8882056);
        }

        @Override
        protected void drawCustomRect() {
            boolean noneElseHovered = true;
            for (GuiButtonSetting button : this.buttons) {
                if (this.field_146127_k == button.field_146127_k || !button.func_146115_a()) continue;
                noneElseHovered = false;
                break;
            }
            boolean selected = this.selected && noneElseHovered || this.func_146115_a();
            GuiButtonSetting.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)(selected ? this.colorFirst : this.colorSecond));
        }

        public void setButtonList(List<GuiButtonSetting> buttons) {
            this.buttons = buttons;
        }
    }
}

