/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.blocks;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.mantle.tileentity.TileInventory;
import slimeknights.tmechworks.TMechworks;
import slimeknights.tmechworks.blocks.logic.RedstoneMachineLogicBase;

public abstract class RedstoneMachine<E extends Enum<E> & IStringSerializable>
extends EnumBlock<E>
implements ITileEntityProvider {
    public static final PropertyEnum<DefaultTypes> DEF_TYPE = PropertyEnum.func_177709_a((String)"type", DefaultTypes.class);
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public boolean dropState = true;
    private TileEntity cachedTE;

    protected RedstoneMachine(Material material, PropertyEnum<E> prop, Class<E> clazz) {
        super(material, prop, clazz);
        this.func_149711_c(2.0f);
        this.func_149752_b(2.0f);
        this.field_149758_A = true;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    protected boolean openGui(EntityPlayer player, World world, BlockPos pos) {
        player.openGui((Object)TMechworks.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.prop, FACING});
    }

    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        RedstoneMachineLogicBase baseLogic = (RedstoneMachineLogicBase)worldIn.func_175625_s(pos);
        EnumFacing face = EnumFacing.NORTH;
        if (baseLogic != null) {
            face = baseLogic.getFacingDirection();
        }
        return state.func_177226_a((IProperty)FACING, (Comparable)face);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos from) {
        RedstoneMachineLogicBase logicBase = (RedstoneMachineLogicBase)worldIn.func_175625_s(pos);
        if (logicBase != null) {
            logicBase.updateRedstone();
        }
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean hasFacingDirection() {
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileInventory) {
            ((TileInventory)tileentity).setCustomName(stack.func_82833_r());
        }
        if (!this.hasFacingDirection()) {
            return;
        }
        RedstoneMachineLogicBase baseLogic = (RedstoneMachineLogicBase)worldIn.func_175625_s(pos);
        if (baseLogic == null) {
            return;
        }
        baseLogic.setFacingDirection(EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public void getDrops(NonNullList<ItemStack> items, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        RedstoneMachineLogicBase tile = (RedstoneMachineLogicBase)world.func_175625_s(pos);
        if (tile == null && this.cachedTE instanceof RedstoneMachineLogicBase) {
            tile = (RedstoneMachineLogicBase)this.cachedTE;
        }
        if (!this.dropState || tile == null) {
            super.getDrops(items, world, pos, state, fortune);
            return;
        }
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        Item item = this.func_180660_a(state, rand, fortune);
        if (item != null) {
            items.add((Object)tile.storeTileData(new ItemStack(item, 1, this.func_180651_a(state))));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (compound.func_150297_b("BlockEntityTag", 10)) {
            ItemStack disguise;
            NBTTagCompound tags = compound.func_74775_l("BlockEntityTag");
            if (tags.func_150297_b("Disguise", 10) && (disguise = new ItemStack(tags.func_74775_l("Disguise"))) != ItemStack.field_190927_a) {
                tooltip.add(ChatFormatting.BOLD + "Disguise:");
                tooltip.add(disguise.func_82833_r());
            }
            if (tags.func_150297_b("Items", 9)) {
                NBTTagList items = tags.func_150295_c("Items", 10);
                if (items.func_74745_c() > 0) {
                    tooltip.add(ChatFormatting.BOLD + "Items:");
                }
                for (int i = 0; i < items.func_74745_c(); ++i) {
                    NBTTagCompound itemTag = items.func_150305_b(i);
                    int slot = itemTag.func_74771_c("Slot") & 0xFF;
                    ItemStack item = new ItemStack(itemTag);
                    tooltip.add("Slot " + slot + ": " + item.func_82833_r() + " x" + item.func_190916_E());
                }
            }
        }
    }

    protected boolean isInvalidNeighbor(World worldIn, BlockPos pos, EnumFacing facing) {
        return worldIn.func_180495_p(pos.func_177972_a(facing)).func_185904_a() == Material.field_151570_A;
    }

    protected boolean hasInvalidNeighbor(World worldIn, BlockPos pos) {
        return this.isInvalidNeighbor(worldIn, pos, EnumFacing.NORTH) || this.isInvalidNeighbor(worldIn, pos, EnumFacing.SOUTH) || this.isInvalidNeighbor(worldIn, pos, EnumFacing.WEST) || this.isInvalidNeighbor(worldIn, pos, EnumFacing.EAST);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public abstract TileEntity func_149915_a(@Nonnull World var1, int var2);

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float clickX, float clickY, float clickZ) {
        if (player.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K) {
            return this.openGui(player, world, pos);
        }
        return true;
    }

    public void func_180663_b(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tileentity;
        this.cachedTE = tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileInventory) {
            if (!this.dropState) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
            }
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public static enum DefaultTypes implements EnumBlock.IEnumMeta,
    IStringSerializable
    {
        NORMAL;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }

        public int getMeta() {
            return this.ordinal();
        }
    }
}

