/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import de.keridos.floodlights.tileentity.TileEntityMetaFloodlight;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityPhantomLight
extends TileEntity {
    private Map<BlockPos, Integer> floodlights = new HashMap<BlockPos, Integer>();
    private Block lightBlock;

    void addSource(BlockPos pos, int floodlightId) {
        if (this.floodlights.containsKey(pos)) {
            return;
        }
        this.floodlights.put(pos, floodlightId);
        this.func_70296_d();
    }

    void removeSource(BlockPos pos) {
        this.removeSource(pos, true);
    }

    private void removeSource(BlockPos pos, boolean updateSources) {
        if (updateSources) {
            this.floodlights.remove(pos);
            this.func_70296_d();
        }
        if (this.floodlights.isEmpty() && this.func_145830_o()) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    public void setLightBlock(Block lightBlock) {
        this.lightBlock = lightBlock;
    }

    public void invalidateSources() {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.floodlights.isEmpty()) {
            Iterator<BlockPos> iter = this.floodlights.keySet().iterator();
            while (iter.hasNext()) {
                boolean remove;
                BlockPos pos = iter.next();
                TileEntity te = this.field_145850_b.func_175625_s(pos);
                if (te instanceof TileEntityMetaFloodlight) {
                    TileEntityMetaFloodlight floodlight = (TileEntityMetaFloodlight)te;
                    int floodlightId = this.floodlights.get(pos);
                    remove = this.lightBlock != floodlight.lightBlock || !floodlight.hasLight() || floodlightId != floodlight.floodlightId;
                } else {
                    remove = true;
                }
                if (!remove) continue;
                this.removeSource(pos, false);
                iter.remove();
            }
        } else {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("sources")) {
            NBTTagList list = nbtTagCompound.func_150295_c("sources", 11);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                int[] array = list.func_150306_c(i);
                if (array.length < 4) continue;
                BlockPos pos = new BlockPos(array[0], array[1], array[2]);
                this.floodlights.put(pos, array[3]);
            }
        }
        this.lightBlock = nbtTagCompound.func_74764_b("lightBlock") ? Block.func_149684_b((String)nbtTagCompound.func_74779_i("lightBlock")) : Blocks.field_150348_b;
        this.invalidateSources();
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound = super.func_189515_b(nbtTagCompound);
        if (!this.floodlights.isEmpty()) {
            NBTTagList SourceList = new NBTTagList();
            for (BlockPos source : this.floodlights.keySet()) {
                int[] array = new int[]{source.func_177958_n(), source.func_177956_o(), source.func_177952_p(), this.floodlights.get(source)};
                SourceList.func_74742_a((NBTBase)new NBTTagIntArray(array));
            }
            nbtTagCompound.func_74782_a("sources", (NBTBase)SourceList);
        }
        nbtTagCompound.func_74778_a("lightBlock", this.lightBlock.getRegistryName().toString());
        return nbtTagCompound;
    }
}

