/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.entity;

import cofh.core.render.ShaderHelper;
import cofh.thermaldynamics.duct.entity.Camera;
import cofh.thermaldynamics.duct.entity.EntityTransport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TransportHandler {
    public static final TransportHandler INSTANCE = new TransportHandler();
    @SideOnly(value=Side.CLIENT)
    Camera camera;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.CLIENT)
    public void renderTravellers(RenderLivingEvent.Pre event) {
        EntityLivingBase entity = event.getEntity();
        Entity ridingEntity = entity.func_184187_bx();
        if (ridingEntity != null && ridingEntity.getClass() == EntityTransport.class) {
            event.setCanceled(true);
            if (entity instanceof EntityPlayer) {
                return;
            }
            float f = ShaderHelper.midGameTick;
            EntityTransport transport = (EntityTransport)ridingEntity;
            transport.setPosition(f);
            ridingEntity.func_184232_k((Entity)entity);
            float rotation = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * f;
            GlStateManager.func_179094_E();
            float max = Math.max(Math.max(Math.max(entity.field_70131_O, entity.field_70130_N), transport.originalWidth), transport.originalHeight);
            GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
            if ((double)max > 0.4) {
                double h = 0.4 / (double)max;
                GlStateManager.func_179137_b((double)0.0, (double)(-h / 2.0), (double)0.0);
                GlStateManager.func_179139_a((double)h, (double)h, (double)h);
            } else {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
            }
            try {
                entity.func_184210_p();
                event.getRenderer().func_76986_a(entity, 0.0, 0.0, 0.0, rotation, f);
            }
            finally {
                entity.func_184220_m((Entity)transport);
            }
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void controlPlayer(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP thePlayer = mc.field_71439_g;
        if (thePlayer == null) {
            return;
        }
        Entity ridingEntity = thePlayer.func_184187_bx();
        if (ridingEntity != null && ridingEntity.getClass() == EntityTransport.class) {
            EntityTransport transport = (EntityTransport)ridingEntity;
            transport.updateRider((Entity)thePlayer);
            if (mc.field_71474_y.field_74320_O != 0) {
                return;
            }
            double rotationYaw = 0.0;
            double rotationPitch = 0.0;
            byte d = transport.direction;
            switch (d) {
                case 0: {
                    rotationPitch = 90.0;
                    break;
                }
                case 1: {
                    rotationPitch = -90.0;
                    break;
                }
                case 2: {
                    rotationYaw = 180.0;
                    break;
                }
                case 3: {
                    rotationYaw = 0.0;
                    break;
                }
                case 4: {
                    rotationYaw = 90.0;
                    break;
                }
                case 5: {
                    rotationYaw = 270.0;
                    break;
                }
                default: {
                    return;
                }
            }
            thePlayer.field_70125_A = (float)((double)thePlayer.field_70125_A + Math.sin((rotationPitch - (double)thePlayer.field_70125_A) / 180.0 * Math.PI) * 30.0);
            if (rotationPitch == 0.0) {
                thePlayer.field_70177_z = (float)((double)thePlayer.field_70177_z + Math.sin((rotationYaw - (double)thePlayer.field_70177_z) / 180.0 * Math.PI) * 30.0);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void controlCamera(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP thePlayer = mc.field_71439_g;
        if (thePlayer == null) {
            return;
        }
        Entity ridingEntity = thePlayer.func_184187_bx();
        if (ridingEntity == null) {
            if (mc.func_175606_aa() != null && mc.func_175606_aa() == this.camera) {
                mc.func_175607_a((Entity)thePlayer);
                this.camera.field_70170_p = null;
            }
        } else if (ridingEntity.getClass() == EntityTransport.class) {
            EntityTransport transport = (EntityTransport)ridingEntity;
            if (this.camera == null) {
                this.camera = new Camera();
            }
            this.camera.copyFromEntityTransport(transport, (EntityPlayer)thePlayer);
            mc.func_175607_a((Entity)this.camera);
        }
    }
}

