/*
 * Decompiled with CFR 0.152.
 */
package com.raden93.veganlife.block.jute;

import com.raden93.veganlife.init.VeganLifeItems;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class JuteCropBlock
extends BlockBush
implements IGrowable {
    public static final int NUM_MAX_AGE = 11;
    private static final int NUM_MIN_AGES_FOR_TOP = 6;
    private static final int NUM_TOP_AGES = 5;
    public static final float GROWTH_CHANCE_PER_UPDATETICK = 0.1f;
    public static final PropertyInteger CROP_AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)11);

    public JuteCropBlock() {
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)CROP_AGE, (Comparable)Integer.valueOf(0)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CROP_AGE});
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float growthPercent = 1.0f;
        if (this.getCurrentAge(state) < 11) {
            int max = this.isBiggerThanOneBlock(state) ? 5 : 6;
            int blockStage = this.getCurrentAge(state) % 6;
            growthPercent = (float)blockStage / (float)max;
        }
        return new AxisAlignedBB((double)0.15f, 0.0, (double)0.15f, (double)0.85f, (double)(0.25f + growthPercent * 0.75f), (double)0.85f);
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)CROP_AGE);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CROP_AGE, (Comparable)Integer.valueOf(meta));
    }

    public void func_180650_b(@Nullable World world, @Nullable BlockPos pos, @Nullable IBlockState state, @Nullable Random random) {
        super.func_180650_b(world, pos, state, random);
        if (this.canGrow(state) && random.nextFloat() < 0.1f) {
            this.growCrop(world, pos, state, 1);
        }
    }

    public boolean func_176473_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(@Nonnull World world, @Nonnull Random random, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return true;
    }

    public void func_176474_b(@Nonnull World world, @Nonnull Random random, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (this.canGrow(state)) {
            int growing_steps = random.nextInt(3) + 2;
            this.growCrop(world, pos, state, growing_steps);
        }
    }

    public float getCurrentStateInProcent(World world, BlockPos pos, IBlockState state) {
        if (this.isBiggerThanOneBlock(state)) {
            return this.getCurrentStateInProcent(world, pos.func_177984_a(), world.func_180495_p(pos.func_177984_a()));
        }
        return (float)this.getCurrentAge(state) / 11.0f;
    }

    private void growCrop(World world, BlockPos pos, IBlockState state, int steps) {
        int currentAge = this.getCurrentAge(state);
        int newAge = currentAge + steps;
        if (currentAge >= 6 && newAge >= 11) {
            world.func_180501_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 0);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 0);
            Blocks.field_150398_cm.func_176491_a(world, pos.func_177977_b(), BlockDoublePlant.EnumPlantType.FERN, 3);
        } else if (currentAge < 6 && newAge >= 6) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)CROP_AGE, (Comparable)Integer.valueOf(11)));
            world.func_175656_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)CROP_AGE, (Comparable)Integer.valueOf(newAge)));
        } else {
            world.func_180501_a(pos, state.func_177226_a((IProperty)CROP_AGE, (Comparable)Integer.valueOf(newAge)), 3);
            return;
        }
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        int currentAge = this.getCurrentAge(state);
        if (currentAge >= 6 && currentAge < 11) {
            return world.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        }
        if (currentAge == 11) {
            return world.func_180495_p(pos.func_177984_a()).func_177230_c() == this;
        }
        return super.func_180671_f(world, pos, state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return VeganLifeItems.jute_seeds_item;
    }

    public int quantityDropped(IBlockState state, int fortune, @Nonnull Random random) {
        return this.getCurrentAge(state) >= 6 ? 0 : 1;
    }

    private int getCurrentAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)CROP_AGE);
    }

    private boolean isBiggerThanOneBlock(IBlockState state) {
        return this.getCurrentAge(state) >= 11;
    }

    private boolean canGrow(IBlockState state) {
        return this.getCurrentAge(state) < 11;
    }
}

