/*
 * Decompiled with CFR 0.152.
 */
package com.mia.props.common;

import java.awt.Color;
import java.util.Locale;

public class ColorsUtil {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Color parseColor(String s) {
        Color returnColor = null;
        s = s.trim().toLowerCase(Locale.US);
        try {
            returnColor = NamedColors.valueOf(s).getColor();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (returnColor != null) return returnColor;
        if (s.startsWith("0x")) {
            String hex = s.substring(2);
            if (hex.length() == 3 || hex.length() == 4) {
                StringBuilder newHex = new StringBuilder();
                for (char c : hex.toCharArray()) {
                    newHex.append(c);
                    newHex.append(c);
                }
                hex = newHex.toString();
            }
            if (hex.length() != 6) {
                if (hex.length() != 8) throw new NumberFormatException("Invalid hex format detected while attempting to parse color value: " + s);
            }
            returnColor = new Color(Integer.parseInt(hex, 16));
            if (hex.length() != 8) return returnColor;
            return new Color(returnColor.getRed(), returnColor.getGreen(), returnColor.getBlue(), Integer.parseInt(hex.substring(0, 2), 16));
        }
        try {
            return new Color(Integer.parseInt(s));
        }
        catch (Exception e) {
            throw new NumberFormatException("Invalid integer format detected while attempting to parse color value: " + s);
        }
    }

    public static enum NamedColors {
        aliceblue(0xF0F8FF),
        antiquewhite(16444375),
        aqua(65535),
        aquamarine(8388564),
        azure(0xF0FFFF),
        beige(16119260),
        bisque(16770244),
        black(0),
        blanchedalmond(16772045),
        blue(255),
        blueviolet(9055202),
        brown(0xA52A2A),
        burlywood(14596231),
        cadetblue(6266528),
        chartreuse(0x7FFF00),
        chocolate(13789470),
        coral(16744272),
        cornflowerblue(6591981),
        cornsilk(16775388),
        crimson(14423100),
        cyan(65535),
        darkblue(139),
        darkcyan(35723),
        darkgoldenrod(12092939),
        darkgray(0xA9A9A9),
        darkgreen(25600),
        darkkhaki(12433259),
        darkmagenta(0x8B008B),
        darkolivegreen(5597999),
        darkorange(16747520),
        darkorchid(10040012),
        darkred(0x8B0000),
        darksalmon(15308410),
        darkseagreen(9419919),
        darkslateblue(4734347),
        darkslategray(0x2F4F4F),
        darkturquoise(52945),
        darkviolet(9699539),
        deeppink(16716947),
        deepskyblue(49151),
        dimgray(0x696969),
        dodgerblue(2003199),
        firebrick(0xB22222),
        floralwhite(0xFFFAF0),
        forestgreen(0x228B22),
        fuchsia(0xFF00FF),
        gainsboro(0xDCDCDC),
        ghostwhite(0xF8F8FF),
        gold(16766720),
        goldenrod(14329120),
        gray(0x808080),
        green(32768),
        greenyellow(11403055),
        honeydew(0xF0FFF0),
        hotpink(16738740),
        indianred(0xCD5C5C),
        indigo(4915330),
        ivory(0xFFFFF0),
        khaki(15787660),
        lavender(15132410),
        lavenderblush(0xFFF0F5),
        lawngreen(8190976),
        lemonchiffon(16775885),
        lightblue(11393254),
        lightcoral(0xF08080),
        lightcyan(0xE0FFFF),
        lightgoldenrodyellow(16448210),
        lightgray(0xD3D3D3),
        lightgreen(0x90EE90),
        lightpink(16758465),
        lightsalmon(16752762),
        lightseagreen(2142890),
        lightskyblue(8900346),
        lightslategray(0x778899),
        lightsteelblue(11584734),
        lightyellow(0xFFFFE0),
        lime(65280),
        limegreen(3329330),
        linen(16445670),
        magenta(0xFF00FF),
        maroon(0x800000),
        mediumaquamarine(6737322),
        mediumblue(205),
        mediumorchid(12211667),
        mediumpurple(9662683),
        mediumseagreen(3978097),
        mediumslateblue(8087790),
        mediumspringgreen(64154),
        mediumturquoise(4772300),
        mediumvioletred(13047173),
        midnightblue(1644912),
        mintcream(0xF5FFFA),
        mistyrose(16770273),
        moccasin(16770229),
        navajowhite(16768685),
        navy(128),
        oldlace(16643558),
        olive(0x808000),
        olivedrab(7048739),
        orange(16753920),
        orangered(16729344),
        orchid(14315734),
        palegoldenrod(0xEEE8AA),
        palegreen(10025880),
        paleturquoise(0xAFEEEE),
        palevioletred(14381203),
        papayawhip(16773077),
        peachpuff(16767673),
        peru(13468991),
        pink(16761035),
        plum(0xDDA0DD),
        powderblue(11591910),
        purple(0x800080),
        rebeccapurple(0x663399),
        red(0xFF0000),
        rosybrown(12357519),
        royalblue(4286945),
        saddlebrown(9127187),
        salmon(16416882),
        sandybrown(16032864),
        seagreen(3050327),
        seashell(0xFFF5EE),
        sienna(10506797),
        silver(0xC0C0C0),
        skyblue(8900331),
        slateblue(6970061),
        slategray(7372944),
        snow(0xFFFAFA),
        springgreen(65407),
        steelblue(4620980),
        tan(13808780),
        teal(32896),
        thistle(14204888),
        tomato(16737095),
        turquoise(4251856),
        violet(0xEE82EE),
        wheat(16113331),
        white(0xFFFFFF),
        whitesmoke(0xF5F5F5),
        yellow(0xFFFF00),
        yellowgreen(10145074),
        mc_stone(0x7D7D7D),
        mc_granite(10056034),
        mc_polished_granite(10449506),
        mc_diorite(0xB3B3B6),
        mc_polished_diorite(0xB7B7B9),
        mc_andesite(0x828383),
        mc_polished_andesite(0x858586),
        mc_grass_block(4278044),
        mc_coarse_dirt(7820603),
        mc_podzol(8017721),
        mc_cobblestone(0x7A7A7A),
        mc_oak_wood_planks(10256206),
        mc_spruce_wood_planks(6769966),
        mc_birch_wood_planks(12825467),
        mc_jungle_wood_planks(10120781),
        mc_acacia_wood_planks(11098931),
        mc_dark_oak_wood_planks(4007698),
        mc_oak_sapling(4679205),
        mc_spruce_sapling(3357217),
        mc_birch_sapling(7771732),
        mc_jungle_sapling(3167762),
        mc_acacia_sapling(7500564),
        mc_dark_oak_sapling(3692060),
        mc_bedrock(0x535353),
        mc_sand(14406560),
        mc_red_sand(11098145),
        mc_gravel(8289402),
        mc_gold_ore(9407356),
        mc_iron_ore(8880766),
        mc_coal_ore(0x737373),
        mc_oak_wood(6705457),
        mc_spruce_wood(2956300),
        mc_birch_wood(0xCECEC9),
        mc_jungle_wood(5718810),
        mc_acacia_wood(6906713),
        mc_dark_oak_wood(3418135),
        mc_oak_leaves(3169061),
        mc_spruce_leaves(2706976),
        mc_birch_leaves(3169061),
        mc_jungle_leaves(3432229),
        mc_acacia_leaves(3169061),
        mc_dark_oak_leaves(3169061),
        mc_sponge(12763988),
        mc_wet_sponge(10526271),
        mc_glass(14348532),
        mc_lapis_lazuli_ore(6713478),
        mc_lapis_lazuli_block(2507657),
        mc_dispenser(0x606060),
        mc_sandstone(14209437),
        mc_chiseled_sandstone(14143642),
        mc_smooth_sandstone(14406561),
        mc_note_block(6570802),
        mc_powered_rail(8678472),
        mc_detector_rail(7890265),
        mc_sticky_piston(6973023),
        mc_cobweb(0xDCDCDC),
        mc_grass(4351033),
        mc_fern(3823922),
        mc_dead_bush(8081177),
        mc_wool(0xDDDDDD),
        mc_orange_wool(14384446),
        mc_magenta_wool(11751612),
        mc_light_blue_wool(6982345),
        mc_yellow_wool(11642407),
        mc_lime_wool(4304440),
        mc_pink_wool(13665433),
        mc_gray_wool(0x404040),
        mc_light_gray_wool(0x9AA1A1),
        mc_cyan_wool(3042953),
        mc_purple_wool(8273333),
        mc_blue_wool(3029133),
        mc_brown_wool(5190175),
        mc_green_wool(3491355),
        mc_red_wool(9843760),
        mc_black_wool(0x191616),
        mc_dandelion(7119360),
        mc_poppy(6568196),
        mc_blue_orchid(2463882),
        mc_allium(11636179),
        mc_azure_bluet(10665866),
        mc_red_tulip(6784806),
        mc_orange_tulip(6260256),
        mc_white_tulip(6199617),
        mc_pink_tulip(6657609),
        mc_oxeye_daisy(11584907),
        mc_minecraftblocksmushroom_brown(9070931),
        mc_minecraftblocksmushroom_red(12793144),
        mc_block_gold(16378958),
        mc_block_iron(0xDBDBDB),
        mc_stone_slab(0xA6A6A6),
        mc_bricks_slab(9593686),
        mc_stone_bricks_slab(0x7A7A7A),
        mc_nether_brick_slab(2889242),
        mc_quartz_slab(15526370),
        mc_tnt(11099207),
        mc_bookshelf(7034937),
        mc_moss_stone(0x677967),
        mc_obsidian(1315357),
        mc_torch(8546874),
        mc_monster_spawner(1713969),
        mc_diamond_ore(8490127),
        mc_block_diamond(6413269),
        mc_crafting_table(7561023),
        mc_minecraftblocksfurnace_front_off(0x4E4E4E),
        mc_minecraftblocksfurnace_front_on(8218197),
        mc_ladder(7954228),
        mc_rail(7957592),
        mc_redstone_ore(8678251),
        mc_redstone_torch(10963753),
        mc_snow(0xEFFBFB),
        mc_ice(8236543),
        mc_cactus(878104),
        mc_clay(10396848),
        mc_jukebox(6570802),
        mc_pumpkin(9325580),
        mc_netherrack(7288372),
        mc_soul_sand(5521459),
        mc_glowstone(9401925),
        mc_jacko_lantern(12158236),
        mc_wooden_trapdoor(8281389),
        mc_mossy_stone_brick_monster_egg(7501674),
        mc_cracked_stone_brick_monster_egg(0x767676),
        mc_chiseled_stone_brick_monster_egg(0x767676),
        mc_minecraftblocksmushroom_block(13282168),
        mc_iron_bars(7171178),
        mc_melon(9277732),
        mc_vines(2051850),
        mc_mycelium(7428169),
        mc_lily_pad(3430955),
        mc_enchantment_table(1183771),
        mc_end_portal(9674875),
        mc_end_stone(14540709),
        mc_dragon_egg(788751),
        mc_redstone_lamp(4598554),
        mc_emerald_ore(7176308),
        mc_block_emerald(5364085),
        mc_command_block(11700591),
        mc_anvil(0x404040),
        mc_daylight_sensor(8549470),
        mc_block_redstone(11213577),
        mc_nether_quartz_ore(8213583),
        mc_hopper(0x3E3E3E),
        mc_quartz(15197404),
        mc_pillar_quartz_block(15197147),
        mc_activator_rail(6837063),
        mc_white_stained_clay(13742753),
        mc_orange_stained_clay(10572581),
        mc_magenta_stained_clay(9787500),
        mc_light_blue_stained_clay(7433353),
        mc_yellow_stained_clay(12223779),
        mc_lime_stained_clay(6780212),
        mc_pink_stained_clay(10571342),
        mc_gray_stained_clay(3746339),
        mc_light_gray_stained_clay(8874593),
        mc_cyan_stained_clay(0x565B5B),
        mc_purple_stained_clay(7751254),
        mc_blue_stained_clay(4864859),
        mc_brown_stained_clay(5059363),
        mc_green_stained_clay(5002026),
        mc_red_stained_clay(9387310),
        mc_black_stained_clay(2430480),
        mc_barrier(13768985),
        mc_iron_trapdoor(0xC7C7C7),
        mc_hay_bale(10318866),
        mc_hardened_clay(9854018),
        mc_block_coal(0x121212),
        mc_packed_ice(10863349),
        mc_slime_block(7915621),
        mc_sunflower(4287787),
        mc_lilac(9344132),
        mc_double_tallgrass(0x8C8C8C),
        mc_large_fern(0x7B7B7B),
        mc_rose_bush(4538371),
        mc_peony(3561531),
        mc_white_stained_glass(0xFFFFFF),
        mc_orange_stained_glass(14188339),
        mc_magenta_stained_glass(11685080),
        mc_light_blue_stained_glass(6724056),
        mc_yellow_stained_glass(0xE5E533),
        mc_lime_stained_glass(8375321),
        mc_pink_stained_glass(15892389),
        mc_gray_stained_glass(0x4C4C4C),
        mc_light_gray_stained_glass(0x999999),
        mc_cyan_stained_glass(5013401),
        mc_purple_stained_glass(8339378),
        mc_blue_stained_glass(3361970),
        mc_brown_stained_glass(6704179),
        mc_green_stained_glass(6717235),
        mc_red_stained_glass(0x993333),
        mc_black_stained_glass(0x191919),
        mc_prismarine(6527117),
        mc_prismarine_bricks(6529167),
        mc_dark_prismarine(3888971),
        mc_sea_lantern(11323326),
        mc_red_sandstone(10834973),
        mc_chiseled_red_sandstone(10637851),
        mc_smooth_red_sandstone(11031838);

        private Color c;

        private NamedColors(int hex) {
            this.c = new Color(hex);
        }

        final Color getColor() {
            return this.c;
        }
    }
}

