/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.JsePlatform;
import org.luaj.vm2.script.LuaScriptEngineFactory;

public class LuaScriptEngine
implements ScriptEngine,
Compilable {
    private static final String __ENGINE_VERSION__ = "Luaj-jse 2.0.3";
    private static final String __NAME__ = "Luaj";
    private static final String __SHORT_NAME__ = "Luaj";
    private static final String __LANGUAGE__ = "lua";
    private static final String __LANGUAGE_VERSION__ = "5.1";
    private static final String __ARGV__ = "arg";
    private static final String __FILENAME__ = "?";
    private static final ScriptEngineFactory myFactory = new LuaScriptEngineFactory();
    private ScriptContext defaultContext;
    private final LuaValue _G = JsePlatform.standardGlobals();

    public LuaScriptEngine() {
        SimpleScriptContext simpleScriptContext = new SimpleScriptContext();
        simpleScriptContext.setBindings(this.createBindings(), 100);
        this.setContext(simpleScriptContext);
        this.put("javax.script.language_version", __LANGUAGE_VERSION__);
        this.put("javax.script.language", __LANGUAGE__);
        this.put("javax.script.engine", "Luaj");
        this.put("javax.script.engine_version", __ENGINE_VERSION__);
        this.put("javax.script.argv", __ARGV__);
        this.put("javax.script.filename", __FILENAME__);
        this.put("javax.script.name", "Luaj");
        this.put("THREADING", null);
    }

    public Object eval(String string) throws ScriptException {
        return this.eval(new StringReader(string));
    }

    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        return this.eval((Reader)new StringReader(string), scriptContext);
    }

    public Object eval(String string, Bindings bindings) throws ScriptException {
        return this.eval((Reader)new StringReader(string), bindings);
    }

    public Object eval(Reader reader) throws ScriptException {
        return this.eval(reader, this.getContext());
    }

    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        return this.compile(reader).eval(scriptContext);
    }

    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        ScriptContext scriptContext = this.getContext();
        Bindings bindings2 = scriptContext.getBindings(100);
        scriptContext.setBindings(bindings, 100);
        Object object = this.eval(reader);
        scriptContext.setBindings(bindings2, 100);
        return object;
    }

    public void put(String string, Object object) {
        Bindings bindings = this.getBindings(100);
        bindings.put(string, object);
    }

    public Object get(String string) {
        Bindings bindings = this.getBindings(100);
        return bindings.get(string);
    }

    public Bindings getBindings(int n) {
        return this.getContext().getBindings(n);
    }

    public void setBindings(Bindings bindings, int n) {
        this.getContext().setBindings(bindings, n);
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    public ScriptContext getContext() {
        return this.defaultContext;
    }

    public void setContext(ScriptContext scriptContext) {
        this.defaultContext = scriptContext;
    }

    public ScriptEngineFactory getFactory() {
        return myFactory;
    }

    public CompiledScript compile(String string) throws ScriptException {
        return this.compile(new StringReader(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompiledScript compile(Reader reader) throws ScriptException {
        try {
            Utf8Encoder utf8Encoder = new Utf8Encoder(reader);
            try {
                LuaFunction luaFunction = LoadState.load(utf8Encoder, "script", null);
                if (luaFunction.isclosure()) {
                    final Prototype prototype = luaFunction.checkclosure().p;
                    CompiledScriptImpl compiledScriptImpl = new CompiledScriptImpl(){

                        protected LuaFunction newFunctionInstance() {
                            return new LuaClosure(prototype, null);
                        }
                    };
                    return compiledScriptImpl;
                }
                final Class<?> clazz = luaFunction.getClass();
                CompiledScriptImpl compiledScriptImpl = new CompiledScriptImpl(){

                    protected LuaFunction newFunctionInstance() throws ScriptException {
                        try {
                            return (LuaFunction)clazz.newInstance();
                        }
                        catch (Exception exception) {
                            throw new ScriptException("instantiation failed: " + exception.toString());
                        }
                    }
                };
                return compiledScriptImpl;
            }
            catch (LuaError luaError) {
                throw new ScriptException(luaError.getMessage());
            }
            finally {
                utf8Encoder.close();
            }
        }
        catch (Exception exception) {
            throw new ScriptException("eval threw " + exception.toString());
        }
    }

    private final class Utf8Encoder
    extends InputStream {
        private final Reader r;
        private final int[] buf = new int[2];
        private int n;

        private Utf8Encoder(Reader reader) {
            this.r = reader;
        }

        public int read() throws IOException {
            if (this.n > 0) {
                return this.buf[--this.n];
            }
            int n = this.r.read();
            if (n < 128) {
                return n;
            }
            this.n = 0;
            if (n < 2048) {
                this.buf[this.n++] = 0x80 | n & 0x3F;
                return 0xC0 | n >> 6 & 0x1F;
            }
            this.buf[this.n++] = 0x80 | n & 0x3F;
            this.buf[this.n++] = 0x80 | n >> 6 & 0x3F;
            return 0xE0 | n >> 12 & 0xF;
        }
    }

    public class ClientBindings {
        public final Bindings b;
        public final LuaTable env;

        public ClientBindings(Bindings bindings) {
            this.b = bindings;
            this.env = new LuaTable();
            this.env.setmetatable(LuaTable.tableOf(new LuaValue[]{LuaValue.INDEX, LuaScriptEngine.this._G}));
            this.copyBindingsToGlobals();
        }

        public void copyBindingsToGlobals() {
            Iterator iterator = this.b.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object object = this.b.get(string);
                LuaValue luaValue = this.toLua(string);
                LuaValue luaValue2 = this.toLua(object);
                this.env.set(luaValue, luaValue2);
                iterator.remove();
            }
        }

        private LuaValue toLua(Object object) {
            return object == null ? LuaValue.NIL : (object instanceof LuaValue ? (LuaValue)object : CoerceJavaToLua.coerce(object));
        }

        public void copyGlobalsToBindings() {
            LuaValue[] luaValueArray = this.env.keys();
            for (int i = 0; i < luaValueArray.length; ++i) {
                LuaValue luaValue = luaValueArray[i];
                LuaValue luaValue2 = this.env.get(luaValue);
                String string = luaValue.tojstring();
                Object object = this.toJava(luaValue2);
                this.b.put(string, object);
            }
        }

        private Object toJava(LuaValue luaValue) {
            switch (luaValue.type()) {
                case 0: {
                    return null;
                }
                case 4: {
                    return luaValue.tojstring();
                }
                case 7: {
                    return luaValue.checkuserdata(Object.class);
                }
                case 3: {
                    return luaValue.isinttype() ? (Number)new Integer(luaValue.toint()) : (Number)new Double(luaValue.todouble());
                }
            }
            return luaValue;
        }
    }

    protected abstract class CompiledScriptImpl
    extends CompiledScript {
        protected CompiledScriptImpl() {
        }

        protected abstract LuaFunction newFunctionInstance() throws ScriptException;

        public ScriptEngine getEngine() {
            return LuaScriptEngine.this;
        }

        public Object eval(ScriptContext scriptContext) throws ScriptException {
            Bindings bindings = scriptContext.getBindings(100);
            LuaFunction luaFunction = this.newFunctionInstance();
            ClientBindings clientBindings = new ClientBindings(bindings);
            luaFunction.setfenv(clientBindings.env);
            Varargs varargs = luaFunction.invoke(LuaValue.NONE);
            clientBindings.copyGlobalsToBindings();
            return varargs;
        }
    }
}

