/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.luaj.vm2.lib.jse.JsePlatform;
import org.luaj.vm2.luajc.LuaJC;

public class luajc {
    private static final String version = "Luaj-jse 2.0.3Copyright (C) 2009 luaj.org";
    private static final String usage = "usage: java -cp luaj-jse.jar,bcel-5.2.jar luajc [options] fileordir [, fileordir ...]\nAvailable options are:\n  -        process stdin\n  -s src\tsource directory\n  -d dir\tdestination directory\n  -p pkg\tpackage prefix to apply to all classes\n  -r\t\trecursively compile all\n  -l\t\tload classes to verify generated bytecode\n  -v   \tverbose\n";
    private String srcdir = null;
    private String destdir = null;
    private boolean recurse = false;
    private boolean verbose = false;
    private boolean loadclasses = false;
    private String pkgprefix = null;
    private List files = new ArrayList();

    private static void usageExit() {
        System.out.println(usage);
        System.exit(-1);
    }

    public static void main(String[] stringArray) throws IOException {
        new luajc(stringArray);
    }

    private luajc(String[] stringArray) throws IOException {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        block8: for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].startsWith("-")) {
                arrayList.add(stringArray[n]);
                continue;
            }
            switch (stringArray[n].charAt(1)) {
                case 's': {
                    if (++n >= stringArray.length) {
                        luajc.usageExit();
                    }
                    this.srcdir = stringArray[n];
                    continue block8;
                }
                case 'd': {
                    if (++n >= stringArray.length) {
                        luajc.usageExit();
                    }
                    this.destdir = stringArray[n];
                    continue block8;
                }
                case 'l': {
                    this.loadclasses = true;
                    continue block8;
                }
                case 'p': {
                    if (++n >= stringArray.length) {
                        luajc.usageExit();
                    }
                    this.pkgprefix = stringArray[n];
                    continue block8;
                }
                case 'r': {
                    this.recurse = true;
                    continue block8;
                }
                case 'v': {
                    this.verbose = true;
                    continue block8;
                }
                default: {
                    luajc.usageExit();
                }
            }
        }
        if (this.verbose) {
            System.out.println(version);
            System.out.println("srcdir: " + this.srcdir);
            System.out.println("destdir: " + this.srcdir);
            System.out.println("files: " + arrayList);
            System.out.println("recurse: " + this.recurse);
        }
        if (arrayList.size() <= 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.collectFiles(this.srcdir + "/" + arrayList.get(n));
        }
        if (this.files.size() <= 0) {
            System.err.println("no files found in " + arrayList);
            System.exit(-1);
        }
        JsePlatform.standardGlobals();
        int n2 = this.files.size();
        for (n = 0; n < n2; ++n) {
            this.processFile((InputFile)this.files.get(n));
        }
    }

    private void collectFiles(String string) {
        File file;
        File file2 = new File(string);
        if (file2.isDirectory() && this.recurse) {
            this.scandir(file2, this.pkgprefix);
        } else if (file2.isFile() && (file = file2.getAbsoluteFile().getParentFile()) != null) {
            this.scanfile(file, file2, this.pkgprefix);
        }
    }

    private void scandir(File file, String string) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            this.scanfile(file, fileArray[i], string);
        }
    }

    private void scanfile(File file, File file2, String string) {
        if (file2.exists()) {
            if (file2.isDirectory() && this.recurse) {
                this.scandir(file2, string != null ? string + "." + file2.getName() : file2.getName());
            } else if (file2.isFile() && file2.getName().endsWith(".lua")) {
                this.files.add(new InputFile(file, file2, string));
            }
        }
    }

    private void processFile(InputFile inputFile) {
        inputFile.outdir.mkdirs();
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (this.verbose) {
                System.out.println("chunk=" + inputFile.luachunkname + " srcfile=" + inputFile.srcfilename);
            }
            FileInputStream fileInputStream = new FileInputStream(inputFile.infile);
            final Hashtable hashtable = LuaJC.getInstance().compileAll(fileInputStream, inputFile.luachunkname, inputFile.srcfilename);
            fileInputStream.close();
            Object object5 = hashtable.keys();
            while (object5.hasMoreElements()) {
                object4 = (String)object5.nextElement();
                object3 = (byte[])hashtable.get(object4);
                if (((String)object4).indexOf(47) >= 0) {
                    object2 = (this.destdir != null ? this.destdir + "/" : "") + ((String)object4).substring(0, ((String)object4).lastIndexOf(47));
                    new File((String)object2).mkdirs();
                }
                object2 = (this.destdir != null ? this.destdir + "/" : "") + (String)object4 + ".class";
                if (this.verbose) {
                    System.out.println("  " + (String)object2 + " (" + ((byte[])object3).length + " bytes)");
                }
                object = new FileOutputStream((String)object2);
                ((FileOutputStream)object).write((byte[])object3);
                ((FileOutputStream)object).close();
            }
            if (this.loadclasses) {
                object5 = new ClassLoader(){

                    public Class findClass(String string) throws ClassNotFoundException {
                        byte[] byArray = (byte[])hashtable.get(string);
                        if (byArray != null) {
                            return this.defineClass(string, byArray, 0, byArray.length);
                        }
                        return super.findClass(string);
                    }
                };
                object4 = hashtable.keys();
                while (object4.hasMoreElements()) {
                    object3 = (String)object4.nextElement();
                    try {
                        object2 = ((ClassLoader)object5).loadClass((String)object3);
                        object = ((Class)object2).newInstance();
                        if (!this.verbose) continue;
                        System.out.println("    loaded " + (String)object3 + " as " + object);
                    }
                    catch (Exception exception) {
                        System.out.flush();
                        System.err.println("    failed to load " + (String)object3 + ": " + exception);
                        System.err.flush();
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println("    failed to load " + inputFile.srcfilename + ": " + exception);
            exception.printStackTrace(System.err);
            System.err.flush();
        }
    }

    class InputFile {
        public String luachunkname;
        public String srcfilename;
        public File infile;
        public File outdir;
        public String javapackage;

        public InputFile(File file, File file2, String string) {
            this.infile = file2;
            String string2 = string != null ? string.replace('.', '/') : null;
            String string3 = string2 != null ? luajc.this.destdir + "/" + string2 : luajc.this.destdir;
            this.javapackage = string;
            this.srcfilename = (string2 != null ? string2 + "/" : "") + this.infile.getName();
            this.luachunkname = (string2 != null ? string2 + "/" : "") + this.infile.getName().substring(0, this.infile.getName().lastIndexOf(46));
            this.infile = file2;
            this.outdir = new File(string3);
        }
    }
}

