/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TurtleInventoryCrafting
extends InventoryCrafting {
    private ITurtleAccess m_turtle;
    private int m_xStart;
    private int m_yStart;

    public TurtleInventoryCrafting(ITurtleAccess turtle) {
        super(null, 0, 0);
        this.m_turtle = turtle;
        this.m_xStart = 0;
        this.m_yStart = 0;
    }

    @Nonnull
    private ItemStack tryCrafting(int xStart, int yStart) {
        this.m_xStart = xStart;
        this.m_yStart = yStart;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                if (x >= this.m_xStart && x < this.m_xStart + 3 && y >= this.m_yStart && y < this.m_yStart + 3 || this.m_turtle.getInventory().func_70301_a(x + y * 4).func_190926_b()) continue;
                return ItemStack.field_190927_a;
            }
        }
        return CraftingManager.func_82787_a((InventoryCrafting)this, (World)this.m_turtle.getWorld());
    }

    public ArrayList<ItemStack> doCrafting(World world, int maxCount) {
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return null;
        }
        ItemStack result = this.tryCrafting(0, 0);
        if (result.func_190926_b()) {
            result = this.tryCrafting(0, 1);
        }
        if (result.func_190926_b()) {
            result = this.tryCrafting(1, 0);
        }
        if (result.func_190926_b()) {
            result = this.tryCrafting(1, 1);
        }
        if (!result.func_190926_b()) {
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            if (maxCount == 0) {
                return results;
            }
            int numToCraft = 1;
            int size = this.func_70302_i_();
            if (maxCount > 1) {
                int minStackSize = 0;
                for (int n = 0; n < size; ++n) {
                    ItemStack stack = this.func_70301_a(n);
                    if (stack.func_190926_b() || minStackSize != 0 && minStackSize <= stack.func_190916_E()) continue;
                    minStackSize = stack.func_190916_E();
                }
                if (minStackSize > 1) {
                    numToCraft = Math.min(minStackSize, result.func_77976_d() / result.func_190916_E());
                    numToCraft = Math.min(numToCraft, maxCount);
                    result.func_190920_e(result.func_190916_E() * numToCraft);
                }
            }
            TurtlePlayer turtlePlayer = new TurtlePlayer((WorldServer)world);
            result.func_77980_a(world, (EntityPlayer)turtlePlayer, numToCraft);
            results.add(result);
            NonNullList remainingItems = CraftingManager.func_180303_b((InventoryCrafting)this, (World)world);
            for (int n = 0; n < size; ++n) {
                ItemStack stack = this.func_70301_a(n);
                if (stack.func_190926_b()) continue;
                this.func_70298_a(n, numToCraft);
                ItemStack replacement = (ItemStack)remainingItems.get(n);
                if (replacement.func_190926_b() || replacement.func_77984_f() && replacement.func_77952_i() >= replacement.func_77958_k()) continue;
                replacement.func_190920_e(Math.min(numToCraft, replacement.func_77976_d()));
                if (this.func_70301_a(n).func_190926_b()) {
                    this.func_70299_a(n, replacement);
                    continue;
                }
                results.add(replacement);
            }
            return results;
        }
        return null;
    }

    @Nonnull
    public ItemStack func_70463_b(int x, int y) {
        if (x >= 0 && x < this.func_174922_i() && y >= 0 && y < this.func_174923_h()) {
            return this.func_70301_a(x + y * this.func_174922_i());
        }
        return ItemStack.field_190927_a;
    }

    public int func_174922_i() {
        return 3;
    }

    public int func_174923_h() {
        return 3;
    }

    private int modifyIndex(int index) {
        int x = this.m_xStart + index % this.func_174922_i();
        int y = this.m_yStart + index / this.func_174923_h();
        if (x >= 0 && x < 4 && y >= 0 && y < 4) {
            return x + y * 4;
        }
        return -1;
    }

    public int func_70302_i_() {
        return this.func_174922_i() * this.func_174923_h();
    }

    @Nonnull
    public ItemStack func_70301_a(int i) {
        i = this.modifyIndex(i);
        return this.m_turtle.getInventory().func_70301_a(i);
    }

    @Nonnull
    public String func_70005_c_() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString("");
    }

    @Nonnull
    public ItemStack func_70304_b(int i) {
        i = this.modifyIndex(i);
        return this.m_turtle.getInventory().func_70304_b(i);
    }

    @Nonnull
    public ItemStack func_70298_a(int i, int size) {
        i = this.modifyIndex(i);
        return this.m_turtle.getInventory().func_70298_a(i, size);
    }

    public void func_70299_a(int i, @Nonnull ItemStack stack) {
        i = this.modifyIndex(i);
        this.m_turtle.getInventory().func_70299_a(i, stack);
    }

    public int func_70297_j_() {
        return this.m_turtle.getInventory().func_70297_j_();
    }

    public void func_70296_d() {
        this.m_turtle.getInventory().func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, @Nonnull ItemStack stack) {
        i = this.modifyIndex(i);
        return this.m_turtle.getInventory().func_94041_b(i, stack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            int j = this.modifyIndex(i);
            this.m_turtle.getInventory().func_70299_a(j, ItemStack.field_190927_a);
        }
    }
}

