/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.items;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.ItemComputerBase;
import dan200.computercraft.shared.turtle.blocks.ITurtleTile;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.items.ITurtleItem;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import dan200.computercraft.shared.util.StringUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ItemTurtleBase
extends ItemComputerBase
implements ITurtleItem {
    protected ItemTurtleBase(Block block) {
        super(block);
        this.func_77625_d(64);
        this.func_77627_a(true);
    }

    public abstract ItemStack create(int var1, String var2, int var3, ITurtleUpgrade var4, ITurtleUpgrade var5, int var6, ResourceLocation var7);

    public void func_150895_a(@Nullable CreativeTabs tabs, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tabs)) {
            return;
        }
        NonNullList all = NonNullList.func_191196_a();
        ComputerCraft.addAllUpgradedTurtles((NonNullList<ItemStack>)all);
        for (ItemStack stack : all) {
            if (stack.func_77973_b() != this) continue;
            list.add((Object)stack);
        }
    }

    public boolean placeBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState newState) {
        if (super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null && tile instanceof ITurtleTile) {
                ITurtleTile turtle = (ITurtleTile)tile;
                this.setupTurtleAfterPlacement(stack, turtle);
            }
            return true;
        }
        return false;
    }

    public void setupTurtleAfterPlacement(@Nonnull ItemStack stack, ITurtleTile turtle) {
        ResourceLocation overlay;
        String label;
        int id = this.getComputerID(stack);
        if (id >= 0) {
            turtle.setComputerID(id);
        }
        if ((label = this.getLabel(stack)) != null) {
            turtle.setLabel(label);
        }
        for (TurtleSide side : TurtleSide.values()) {
            turtle.getAccess().setUpgrade(side, this.getUpgrade(stack, side));
        }
        int fuelLevel = this.getFuelLevel(stack);
        turtle.getAccess().setFuelLevel(fuelLevel);
        int colour = this.getColour(stack);
        if (colour != -1) {
            turtle.getAccess().setColour(colour);
        }
        if ((overlay = this.getOverlay(stack)) != null) {
            ((TurtleBrain)turtle.getAccess()).setOverlay(overlay);
        }
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack stack) {
        ComputerFamily family = this.getFamily(stack);
        switch (family) {
            default: {
                return "tile.computercraft:turtle";
            }
            case Advanced: {
                return "tile.computercraft:advanced_turtle";
            }
            case Beginners: 
        }
        return "tile.computercraftedu:beginner_turtle";
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        String baseString = this.func_77667_c(stack);
        ITurtleUpgrade left = this.getUpgrade(stack, TurtleSide.Left);
        ITurtleUpgrade right = this.getUpgrade(stack, TurtleSide.Right);
        if (left != null && right != null) {
            return StringUtil.translateToLocalFormatted(baseString + ".upgraded_twice.name", StringUtil.translateToLocal(right.getUnlocalisedAdjective()), StringUtil.translateToLocal(left.getUnlocalisedAdjective()));
        }
        if (left != null) {
            return StringUtil.translateToLocalFormatted(baseString + ".upgraded.name", StringUtil.translateToLocal(left.getUnlocalisedAdjective()));
        }
        if (right != null) {
            return StringUtil.translateToLocalFormatted(baseString + ".upgraded.name", StringUtil.translateToLocal(right.getUnlocalisedAdjective()));
        }
        return StringUtil.translateToLocal(baseString + ".name");
    }

    @Override
    public ItemStack setColour(ItemStack stack, int colour) {
        return TurtleItemFactory.create(this.getComputerID(stack), this.getLabel(stack), colour, this.getFamily(stack), this.getUpgrade(stack, TurtleSide.Left), this.getUpgrade(stack, TurtleSide.Right), this.getFuelLevel(stack), this.getOverlay(stack));
    }
}

