/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.inventory;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerTurtle
extends Container
implements IContainerComputer {
    private static final int PROGRESS_ID_SELECTED_SLOT = 0;
    public final int m_playerInvStartY;
    public final int m_turtleInvStartX;
    protected ITurtleAccess m_turtle;
    private IComputer m_computer;
    private int m_selectedSlot;

    protected ContainerTurtle(IInventory playerInventory, ITurtleAccess turtle, int playerInvStartY, int turtleInvStartX) {
        int x;
        int y;
        this.m_playerInvStartY = playerInvStartY;
        this.m_turtleInvStartX = turtleInvStartX;
        this.m_turtle = turtle;
        this.m_selectedSlot = !this.m_turtle.getWorld().field_72995_K ? this.m_turtle.getSelectedSlot() : 0;
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 4; ++x) {
                this.func_75146_a(new Slot(this.m_turtle.getInventory(), x + y * 4, turtleInvStartX + 1 + x * 18, playerInvStartY + 1 + y * 18));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot(playerInventory, x + y * 9 + 9, 8 + x * 18, playerInvStartY + 1 + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.func_75146_a(new Slot(playerInventory, x2, 8 + x2 * 18, playerInvStartY + 54 + 5));
        }
    }

    public ContainerTurtle(IInventory playerInventory, ITurtleAccess turtle) {
        this(playerInventory, turtle, 134, 175);
    }

    public ContainerTurtle(IInventory playerInventory, ITurtleAccess turtle, IComputer computer) {
        this(playerInventory, turtle);
        this.m_computer = computer;
    }

    public int getSelectedSlot() {
        return this.m_selectedSlot;
    }

    private void sendStateToPlayer(IContainerListener icrafting) {
        int selectedSlot = this.m_turtle.getSelectedSlot();
        icrafting.func_71112_a((Container)this, 0, selectedSlot);
    }

    public void func_75132_a(IContainerListener crafting) {
        super.func_75132_a(crafting);
        this.sendStateToPlayer(crafting);
    }

    public void func_75142_b() {
        super.func_75142_b();
        int selectedSlot = this.m_turtle.getSelectedSlot();
        for (IContainerListener listener : this.field_75149_d) {
            if (this.m_selectedSlot == selectedSlot) continue;
            listener.func_71112_a((Container)this, 0, selectedSlot);
        }
        this.m_selectedSlot = selectedSlot;
    }

    public void func_75137_b(int id, int value) {
        super.func_75137_b(id, value);
        switch (id) {
            case 0: {
                this.m_selectedSlot = value;
            }
        }
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        TileTurtle turtle = ((TurtleBrain)this.m_turtle).getOwner();
        if (turtle != null) {
            return turtle.func_70300_a(player);
        }
        return false;
    }

    @Nonnull
    protected ItemStack tryItemMerge(EntityPlayer player, int slotNum, int firstSlot, int lastSlot, boolean reverse) {
        Slot slot = (Slot)this.field_75151_b.get(slotNum);
        ItemStack originalStack = ItemStack.field_190927_a;
        if (slot != null && slot.func_75216_d()) {
            ItemStack clickedStack = slot.func_75211_c();
            originalStack = clickedStack.func_77946_l();
            if (!this.func_75135_a(clickedStack, firstSlot, lastSlot, reverse)) {
                return ItemStack.field_190927_a;
            }
            if (clickedStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (clickedStack.func_190916_E() != originalStack.func_190916_E()) {
                slot.func_190901_a(player, clickedStack);
            } else {
                return ItemStack.field_190927_a;
            }
        }
        return originalStack;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotNum) {
        if (slotNum >= 0 && slotNum < 16) {
            return this.tryItemMerge(player, slotNum, 16, 52, true);
        }
        if (slotNum >= 16) {
            return this.tryItemMerge(player, slotNum, 0, 16, false);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    @Nullable
    public IComputer getComputer() {
        return this.m_computer;
    }
}

