/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.util.InventoryUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.items.IItemHandler;

public class TurtleRefuelCommand
implements ITurtleCommand {
    private final int m_limit;

    public TurtleRefuelCommand(int limit) {
        this.m_limit = limit;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        if (this.m_limit == 0) {
            ItemStack dummyStack = turtle.getInventory().func_70301_a(turtle.getSelectedSlot());
            if (!dummyStack.func_190926_b()) {
                return this.refuel(turtle, dummyStack, true);
            }
        } else {
            ItemStack stack = InventoryUtil.takeItems(this.m_limit, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot(), 1, turtle.getSelectedSlot());
            if (!stack.func_190926_b()) {
                TurtleCommandResult result = this.refuel(turtle, stack, false);
                if (!result.isSuccess()) {
                    InventoryUtil.storeItems(stack, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot());
                }
                return result;
            }
        }
        return TurtleCommandResult.failure("No items to combust");
    }

    private int getFuelPerItem(@Nonnull ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack) * 5 / 100;
    }

    private TurtleCommandResult refuel(ITurtleAccess turtle, @Nonnull ItemStack stack, boolean testOnly) {
        int fuelPerItem = this.getFuelPerItem(stack);
        if (fuelPerItem <= 0) {
            return TurtleCommandResult.failure("Items not combustible");
        }
        if (!testOnly) {
            int fuelToGive = fuelPerItem * stack.func_190916_E();
            ItemStack replacementStack = stack.func_77973_b().getContainerItem(stack);
            turtle.addFuel(fuelToGive);
            if (!replacementStack.func_190926_b()) {
                InventoryUtil.storeItems(replacementStack, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot());
            }
            turtle.playAnimation(TurtleAnimation.Wait);
        }
        return TurtleCommandResult.success();
    }
}

