/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.upgrades.TurtleInventoryCrafting;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;

public class TurtleCraftCommand
implements ITurtleCommand {
    private final int m_limit;

    public TurtleCraftCommand(int limit) {
        this.m_limit = limit;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        TurtleInventoryCrafting crafting = new TurtleInventoryCrafting(turtle);
        ArrayList<ItemStack> results = crafting.doCrafting(turtle.getWorld(), this.m_limit);
        if (results != null) {
            for (ItemStack stack : results) {
                ItemStack remainder = InventoryUtil.storeItems(stack, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot());
                if (remainder.func_190926_b()) continue;
                BlockPos position = turtle.getPosition();
                WorldUtil.dropItemStack(remainder, turtle.getWorld(), position, turtle.getDirection());
            }
            if (results.size() > 0) {
                turtle.playAnimation(TurtleAnimation.Wait);
            }
            return TurtleCommandResult.success();
        }
        return TurtleCommandResult.failure("No matching recipes");
    }
}

