/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.WorldUtil;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class TurtleCompareCommand
implements ITurtleCommand {
    private final InteractDirection m_direction;

    public TurtleCompareCommand(InteractDirection direction) {
        this.m_direction = direction;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        IBlockState lookAtState;
        Block lookAtBlock;
        EnumFacing direction = this.m_direction.toWorldDir(turtle);
        ItemStack selectedStack = turtle.getInventory().func_70301_a(turtle.getSelectedSlot());
        World world = turtle.getWorld();
        BlockPos oldPosition = turtle.getPosition();
        BlockPos newPosition = oldPosition.func_177972_a(direction);
        ItemStack lookAtStack = ItemStack.field_190927_a;
        if (WorldUtil.isBlockInWorld(world, newPosition) && !world.func_175623_d(newPosition) && !(lookAtBlock = (lookAtState = world.func_180495_p(newPosition)).func_177230_c()).isAir(lookAtState, (IBlockAccess)world, newPosition)) {
            if (!lookAtBlock.hasTileEntity(lookAtState)) {
                try {
                    Method method = ReflectionHelper.findMethod(Block.class, (String)"func_180643_i", (String)"getSilkTouchDrop", (Class[])new Class[]{IBlockState.class});
                    lookAtStack = (ItemStack)method.invoke((Object)lookAtBlock, lookAtState);
                }
                catch (Exception method) {
                    // empty catch block
                }
            }
            block2: for (int i = 0; i < 5 && lookAtStack.func_190926_b(); ++i) {
                NonNullList drops = NonNullList.func_191196_a();
                lookAtBlock.getDrops(drops, (IBlockAccess)world, newPosition, lookAtState, 0);
                if (drops.size() <= 0) continue;
                for (ItemStack drop : drops) {
                    if (drop.func_77973_b() != Item.func_150898_a((Block)lookAtBlock)) continue;
                    lookAtStack = drop;
                    continue block2;
                }
            }
            if (lookAtStack.func_190926_b()) {
                Item item = Item.func_150898_a((Block)lookAtBlock);
                lookAtStack = item != null && item.func_77614_k() ? new ItemStack(item, 1, lookAtBlock.func_176201_c(lookAtState)) : new ItemStack(item, 1, 0);
            }
        }
        if (selectedStack.func_190926_b() && lookAtStack.func_190926_b()) {
            return TurtleCommandResult.success();
        }
        if (!selectedStack.func_190926_b() && lookAtStack != null && selectedStack.func_77973_b() == lookAtStack.func_77973_b()) {
            if (!selectedStack.func_77981_g()) {
                return TurtleCommandResult.success();
            }
            if (selectedStack.func_77952_i() == lookAtStack.func_77952_i()) {
                return TurtleCommandResult.success();
            }
            if (selectedStack.func_77977_a().equals(lookAtStack.func_77977_a())) {
                return TurtleCommandResult.success();
            }
        }
        return TurtleCommandResult.failure();
    }
}

