/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.common;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.shared.computer.blocks.ComputerPeripheral;
import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.peripheral.common.IPeripheralTile;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DefaultPeripheralProvider
implements IPeripheralProvider {
    @Override
    public IPeripheral getPeripheral(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            if (tile instanceof IPeripheralTile) {
                IPeripheralTile peripheralTile = (IPeripheralTile)tile;
                return peripheralTile.getPeripheral(side);
            }
            if (tile instanceof TileComputerBase) {
                TileComputerBase computerTile = (TileComputerBase)tile;
                if (tile instanceof TileTurtle) {
                    if (!((TileTurtle)tile).hasMoved()) {
                        return new ComputerPeripheral("turtle", computerTile.createServerComputer());
                    }
                } else {
                    return new ComputerPeripheral("computer", computerTile.createServerComputer());
                }
            }
        }
        return null;
    }
}

