/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.common;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.common.BlockCableModemVariant;
import dan200.computercraft.shared.peripheral.common.BlockPeripheralBase;
import dan200.computercraft.shared.peripheral.common.ItemCable;
import dan200.computercraft.shared.peripheral.common.TilePeripheralBase;
import dan200.computercraft.shared.peripheral.modem.TileCable;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockCable
extends BlockPeripheralBase {
    public static boolean isCable(IBlockAccess world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == ComputerCraft.Blocks.cable) {
            switch (ComputerCraft.Blocks.cable.getPeripheralType(world, pos)) {
                case Cable: 
                case WiredModemWithCable: {
                    return true;
                }
            }
        }
        return false;
    }

    public BlockCable() {
        this.func_149711_c(1.5f);
        this.func_149663_c("computercraft:cable");
        this.func_149647_a(ComputerCraft.mainCreativeTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(Properties.MODEM, (Comparable)((Object)BlockCableModemVariant.None)).func_177226_a((IProperty)Properties.CABLE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)Properties.NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)Properties.SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)Properties.EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)Properties.WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)Properties.UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)Properties.DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Properties.MODEM, Properties.CABLE, Properties.NORTH, Properties.SOUTH, Properties.EAST, Properties.WEST, Properties.UP, Properties.DOWN});
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if (meta < 6) {
            state = state.func_177226_a((IProperty)Properties.CABLE, (Comparable)Boolean.valueOf(false));
            state = state.func_177226_a(Properties.MODEM, (Comparable)((Object)BlockCableModemVariant.fromFacing(EnumFacing.func_82600_a((int)meta))));
        } else if (meta < 12) {
            state = state.func_177226_a((IProperty)Properties.CABLE, (Comparable)Boolean.valueOf(true));
            state = state.func_177226_a(Properties.MODEM, (Comparable)((Object)BlockCableModemVariant.fromFacing(EnumFacing.func_82600_a((int)(meta - 6)))));
        } else if (meta == 13) {
            state = state.func_177226_a((IProperty)Properties.CABLE, (Comparable)Boolean.valueOf(true));
            state = state.func_177226_a(Properties.MODEM, (Comparable)((Object)BlockCableModemVariant.None));
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        boolean cable = (Boolean)state.func_177229_b((IProperty)Properties.CABLE);
        BlockCableModemVariant modem = (BlockCableModemVariant)((Object)state.func_177229_b(Properties.MODEM));
        if (cable && modem != BlockCableModemVariant.None) {
            meta = 6 + modem.getFacing().func_176745_a();
        } else if (modem != BlockCableModemVariant.None) {
            meta = modem.getFacing().func_176745_a();
        } else if (cable) {
            meta = 13;
        }
        return meta;
    }

    @Override
    public IBlockState getDefaultBlockState(PeripheralType type, EnumFacing placedSide) {
        switch (type) {
            case Cable: {
                return this.func_176223_P().func_177226_a((IProperty)Properties.CABLE, (Comparable)Boolean.valueOf(true)).func_177226_a(Properties.MODEM, (Comparable)((Object)BlockCableModemVariant.None));
            }
            default: {
                return this.func_176223_P().func_177226_a((IProperty)Properties.CABLE, (Comparable)Boolean.valueOf(false)).func_177226_a(Properties.MODEM, (Comparable)((Object)BlockCableModemVariant.fromFacing(placedSide.func_176734_d())));
            }
            case WiredModemWithCable: 
        }
        return this.func_176223_P().func_177226_a((IProperty)Properties.CABLE, (Comparable)Boolean.valueOf(true)).func_177226_a(Properties.MODEM, (Comparable)((Object)BlockCableModemVariant.fromFacing(placedSide.func_176734_d())));
    }

    private boolean doesConnect(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing dir) {
        if (!((Boolean)state.func_177229_b((IProperty)Properties.CABLE)).booleanValue()) {
            return false;
        }
        if (((BlockCableModemVariant)((Object)state.func_177229_b(Properties.MODEM))).getFacing() == dir) {
            return true;
        }
        return BlockCable.isCable(world, pos.func_177972_a(dir));
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        int anim;
        state = state.func_177226_a((IProperty)Properties.NORTH, (Comparable)Boolean.valueOf(this.doesConnect(state, world, pos, EnumFacing.NORTH)));
        state = state.func_177226_a((IProperty)Properties.SOUTH, (Comparable)Boolean.valueOf(this.doesConnect(state, world, pos, EnumFacing.SOUTH)));
        state = state.func_177226_a((IProperty)Properties.EAST, (Comparable)Boolean.valueOf(this.doesConnect(state, world, pos, EnumFacing.EAST)));
        state = state.func_177226_a((IProperty)Properties.WEST, (Comparable)Boolean.valueOf(this.doesConnect(state, world, pos, EnumFacing.WEST)));
        state = state.func_177226_a((IProperty)Properties.UP, (Comparable)Boolean.valueOf(this.doesConnect(state, world, pos, EnumFacing.UP)));
        state = state.func_177226_a((IProperty)Properties.DOWN, (Comparable)Boolean.valueOf(this.doesConnect(state, world, pos, EnumFacing.DOWN)));
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TilePeripheralBase) {
            TilePeripheralBase peripheral = (TilePeripheralBase)tile;
            anim = peripheral.getAnim();
        } else {
            anim = 0;
        }
        BlockCableModemVariant modem = (BlockCableModemVariant)((Object)state.func_177229_b(Properties.MODEM));
        if (modem != BlockCableModemVariant.None) {
            modem = BlockCableModemVariant.values()[1 + 6 * anim + modem.getFacing().func_176745_a()];
        }
        state = state.func_177226_a(Properties.MODEM, (Comparable)((Object)modem));
        return state;
    }

    @Deprecated
    public boolean func_176225_a(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public PeripheralType getPeripheralType(int damage) {
        return ((ItemCable)Item.func_150898_a((Block)this)).getPeripheralType(damage);
    }

    @Override
    public PeripheralType getPeripheralType(IBlockState state) {
        boolean cable = (Boolean)state.func_177229_b((IProperty)Properties.CABLE);
        BlockCableModemVariant modem = (BlockCableModemVariant)((Object)state.func_177229_b(Properties.MODEM));
        if (cable && modem != BlockCableModemVariant.None) {
            return PeripheralType.WiredModemWithCable;
        }
        if (modem != BlockCableModemVariant.None) {
            return PeripheralType.WiredModem;
        }
        return PeripheralType.Cable;
    }

    @Override
    public TilePeripheralBase createTile(PeripheralType type) {
        return new TileCable();
    }

    @Deprecated
    public final boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public final boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    public static class Properties {
        public static final PropertyEnum<BlockCableModemVariant> MODEM = PropertyEnum.func_177709_a((String)"modem", BlockCableModemVariant.class);
        public static final PropertyBool CABLE = PropertyBool.func_177716_a((String)"cable");
        public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
        public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
        public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
        public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
        public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
        public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    }
}

