/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import com.google.common.base.Predicate;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.computer.blocks.BlockComputerBase;
import dan200.computercraft.shared.computer.blocks.ComputerState;
import dan200.computercraft.shared.computer.blocks.IComputerTile;
import dan200.computercraft.shared.computer.blocks.TileComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.items.ItemComputer;
import dan200.computercraft.shared.util.DirectionUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockComputer
extends BlockComputerBase {
    public BlockComputer() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149663_c("computercraft:computer");
        this.func_149647_a(ComputerCraft.mainCreativeTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)Properties.FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)Properties.ADVANCED, (Comparable)Boolean.valueOf(false)).func_177226_a(Properties.STATE, (Comparable)((Object)ComputerState.Off)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Properties.FACING, Properties.ADVANCED, Properties.STATE});
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        EnumFacing dir = EnumFacing.func_82600_a((int)(meta & 7));
        if (dir.func_176740_k() == EnumFacing.Axis.Y) {
            dir = EnumFacing.NORTH;
        }
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)Properties.FACING, (Comparable)dir);
        state = meta > 8 ? state.func_177226_a((IProperty)Properties.ADVANCED, (Comparable)Boolean.valueOf(true)) : state.func_177226_a((IProperty)Properties.ADVANCED, (Comparable)Boolean.valueOf(false));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)Properties.FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)Properties.ADVANCED)).booleanValue()) {
            meta += 8;
        }
        return meta;
    }

    @Override
    protected IBlockState getDefaultBlockState(ComputerFamily family, EnumFacing placedSide) {
        IBlockState state = this.func_176223_P();
        if (placedSide.func_176740_k() != EnumFacing.Axis.Y) {
            state = state.func_177226_a((IProperty)Properties.FACING, (Comparable)placedSide);
        }
        switch (family) {
            default: {
                return state.func_177226_a((IProperty)Properties.ADVANCED, (Comparable)Boolean.valueOf(false));
            }
            case Advanced: 
        }
        return state.func_177226_a((IProperty)Properties.ADVANCED, (Comparable)Boolean.valueOf(true));
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        IComputer computer;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof IComputerTile && (computer = ((IComputerTile)tile).getComputer()) != null && computer.isOn()) {
            if (computer.isCursorDisplayed()) {
                return state.func_177226_a(Properties.STATE, (Comparable)((Object)ComputerState.Blinking));
            }
            return state.func_177226_a(Properties.STATE, (Comparable)((Object)ComputerState.On));
        }
        return state.func_177226_a(Properties.STATE, (Comparable)((Object)ComputerState.Off));
    }

    @Override
    public ComputerFamily getFamily(int damage) {
        return ((ItemComputer)Item.func_150898_a((Block)this)).getFamily(damage);
    }

    @Override
    public ComputerFamily getFamily(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)Properties.ADVANCED)).booleanValue()) {
            return ComputerFamily.Advanced;
        }
        return ComputerFamily.Normal;
    }

    @Override
    protected TileComputer createTile(ComputerFamily family) {
        return new TileComputer();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, @Nonnull ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileComputer) {
            tile.func_145834_a(world);
            tile.func_174878_a(pos);
        }
        EnumFacing dir = DirectionUtil.fromEntityRot(player);
        this.setDirection(world, pos, dir);
    }

    public static class Properties {
        public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
        public static final PropertyBool ADVANCED = PropertyBool.func_177716_a((String)"advanced");
        public static final PropertyEnum<ComputerState> STATE = PropertyEnum.func_177709_a((String)"state", ComputerState.class);
    }
}

