/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.common;

import dan200.computercraft.shared.common.TileGeneric;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockGeneric
extends Block
implements ITileEntityProvider {
    protected BlockGeneric(Material material) {
        super(material);
        this.field_149758_A = true;
    }

    protected abstract IBlockState getDefaultBlockState(int var1, EnumFacing var2);

    protected abstract TileGeneric createTile(IBlockState var1);

    protected abstract TileGeneric createTile(int var1);

    public final void func_180653_a(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, float chance, int fortune) {
    }

    public final void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            generic.getDroppedItems(drops, false);
        }
    }

    @Nonnull
    @Deprecated
    public final IBlockState func_180642_a(World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, int damage, EntityLivingBase placer) {
        return this.getDefaultBlockState(damage, side);
    }

    public final boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (!world.field_72995_K) {
            boolean creative = player.field_71075_bZ.field_75098_d;
            this.dropAllItems(world, pos, creative);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public final void dropAllItems(World world, BlockPos pos, boolean creative) {
        NonNullList drops = NonNullList.func_191196_a();
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            generic.getDroppedItems((NonNullList<ItemStack>)drops, creative);
        }
        if (drops.size() > 0) {
            for (ItemStack item : drops) {
                this.dropItem(world, pos, item);
            }
        }
    }

    public final void dropItem(World world, BlockPos pos, @Nonnull ItemStack stack) {
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
    }

    public final void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState newState) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            generic.destroy();
        }
        super.func_180663_b(world, pos, newState);
        world.func_175713_t(pos);
    }

    @Nonnull
    public final ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            return generic.getPickedItem();
        }
        return ItemStack.field_190927_a;
    }

    public final boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            return generic.onActivate(player, side, hitX, hitY, hitZ);
        }
        return false;
    }

    @Deprecated
    public final void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighorPos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            generic.onNeighbourChange();
        }
    }

    public final void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbour) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            generic.onNeighbourTileEntityChange(neighbour);
        }
    }

    @Deprecated
    public final boolean isSideSolid(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            return generic.isSolidOnSide(side.ordinal());
        }
        return false;
    }

    public final boolean canBeReplacedByLeaves(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return false;
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        TileGeneric generic;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric && tile.func_145830_o() && (generic = (TileGeneric)tile).isImmuneToExplosion(exploder)) {
            return 2000.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    @Nonnull
    @Deprecated
    public final AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric && tile.func_145830_o()) {
            TileGeneric generic = (TileGeneric)tile;
            return generic.getBounds();
        }
        return field_185505_j;
    }

    @Nonnull
    @Deprecated
    public final AxisAlignedBB func_180640_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
        return this.func_185496_a(state, (IBlockAccess)world, pos).func_186670_a(pos);
    }

    @Deprecated
    public final AxisAlignedBB func_180646_a(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric && tile.func_145830_o()) {
            TileGeneric generic = (TileGeneric)tile;
            ArrayList<AxisAlignedBB> collision = new ArrayList<AxisAlignedBB>(1);
            generic.getCollisionBounds(collision);
            if (collision.size() > 0) {
                AxisAlignedBB aabb = (AxisAlignedBB)collision.get(0);
                for (int i = 1; i < collision.size(); ++i) {
                    aabb = aabb.func_111270_a((AxisAlignedBB)collision.get(i));
                }
                return aabb;
            }
        }
        return field_185505_j;
    }

    @Deprecated
    public final void func_185477_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB bigBox, @Nonnull List<AxisAlignedBB> list, Entity entity, boolean p_185477_7_) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric && tile.func_145830_o()) {
            TileGeneric generic = (TileGeneric)tile;
            ArrayList<AxisAlignedBB> collision = new ArrayList<AxisAlignedBB>(1);
            generic.getCollisionBounds(collision);
            if (collision.size() > 0) {
                for (AxisAlignedBB localBounds : collision) {
                    BlockGeneric.func_185492_a((BlockPos)pos, (AxisAlignedBB)bigBox, list, (AxisAlignedBB)localBounds);
                }
            }
        }
    }

    @Deprecated
    public final boolean func_149744_f(IBlockState state) {
        return true;
    }

    public final boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            return generic.getRedstoneConnectivity(side);
        }
        return false;
    }

    @Deprecated
    public final int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing oppositeSide) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric && tile.func_145830_o()) {
            TileGeneric generic = (TileGeneric)tile;
            return generic.getRedstoneOutput(oppositeSide.func_176734_d());
        }
        return 0;
    }

    @Deprecated
    public final int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing oppositeSide) {
        return this.func_176211_b(state, world, pos, oppositeSide);
    }

    public boolean getBundledRedstoneConnectivity(World world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            return generic.getBundledRedstoneConnectivity(side);
        }
        return false;
    }

    public int getBundledRedstoneOutput(World world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric && tile.func_145830_o()) {
            TileGeneric generic = (TileGeneric)tile;
            return generic.getBundledRedstoneOutput(side);
        }
        return 0;
    }

    @Deprecated
    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int eventID, int eventParameter) {
        TileEntity tile;
        if (world.field_72995_K && (tile = world.func_175625_s(pos)) != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            generic.onBlockEvent(eventID, eventParameter);
        }
        return true;
    }

    @Nonnull
    public final TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return this.createTile(state);
    }

    @Nonnull
    public final TileEntity func_149915_a(@Nonnull World world, int damage) {
        return this.createTile(damage);
    }
}

