/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.lua;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.lua.ILuaTask;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ILuaAPI;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.computer.ITask;
import dan200.computercraft.core.computer.MainThread;
import dan200.computercraft.core.lua.ILuaMachine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.OrphanedThread;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;
import org.luaj.vm2.lib.jse.JsePlatform;

public class LuaJLuaMachine
implements ILuaMachine {
    private Computer m_computer;
    private LuaValue m_globals;
    private LuaValue m_loadString;
    private LuaValue m_assert;
    private LuaValue m_coroutine_create;
    private LuaValue m_coroutine_resume;
    private LuaValue m_coroutine_yield;
    private LuaValue m_mainRoutine;
    private String m_eventFilter;
    private String m_softAbortMessage;
    private String m_hardAbortMessage;
    private Map<Object, LuaValue> m_valuesInProgress;
    private Map<LuaValue, Object> m_objectsInProgress;

    public LuaJLuaMachine(Computer computer) {
        this.m_computer = computer;
        this.m_globals = JsePlatform.debugGlobals();
        this.m_loadString = this.m_globals.get("loadstring");
        this.m_assert = this.m_globals.get("assert");
        LuaValue coroutine = this.m_globals.get("coroutine");
        final LuaValue native_coroutine_create = coroutine.get("create");
        LuaValue debug = this.m_globals.get("debug");
        final LuaValue debug_sethook = debug.get("sethook");
        coroutine.set("create", (LuaValue)new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue value) {
                LuaThread thread = native_coroutine_create.call(value).checkthread();
                debug_sethook.invoke(new LuaValue[]{thread, new ZeroArgFunction(){

                    @Override
                    public LuaValue call() {
                        String hardAbortMessage = LuaJLuaMachine.this.m_hardAbortMessage;
                        if (hardAbortMessage != null) {
                            LuaThread.yield(LuaValue.NIL);
                        }
                        return LuaValue.NIL;
                    }
                }, LuaValue.NIL, LuaValue.valueOf(100000)});
                return thread;
            }
        });
        this.m_coroutine_create = coroutine.get("create");
        this.m_coroutine_resume = coroutine.get("resume");
        this.m_coroutine_yield = coroutine.get("yield");
        this.m_globals.set("collectgarbage", LuaValue.NIL);
        this.m_globals.set("dofile", LuaValue.NIL);
        this.m_globals.set("loadfile", LuaValue.NIL);
        this.m_globals.set("module", LuaValue.NIL);
        this.m_globals.set("require", LuaValue.NIL);
        this.m_globals.set("package", LuaValue.NIL);
        this.m_globals.set("io", LuaValue.NIL);
        this.m_globals.set("os", LuaValue.NIL);
        this.m_globals.set("print", LuaValue.NIL);
        this.m_globals.set("luajava", LuaValue.NIL);
        this.m_globals.set("debug", LuaValue.NIL);
        this.m_globals.set("newproxy", LuaValue.NIL);
        this.m_globals.set("__inext", LuaValue.NIL);
        this.m_globals.set("_VERSION", "Lua 5.1");
        this.m_globals.set("_HOST", computer.getAPIEnvironment().getComputerEnvironment().getHostString());
        this.m_globals.set("_CC_DEFAULT_SETTINGS", this.toValue(ComputerCraft.default_computer_settings));
        if (ComputerCraft.disable_lua51_features) {
            this.m_globals.set("_CC_DISABLE_LUA51_FEATURES", this.toValue(true));
        }
        this.m_mainRoutine = null;
        this.m_eventFilter = null;
        this.m_softAbortMessage = null;
        this.m_hardAbortMessage = null;
    }

    @Override
    public void addAPI(ILuaAPI api) {
        String[] names;
        LuaTable table = this.wrapLuaObject(api);
        for (String name : names = api.getNames()) {
            this.m_globals.set(name, (LuaValue)table);
        }
    }

    @Override
    public void loadBios(InputStream bios) {
        block8: {
            if (this.m_mainRoutine != null) {
                return;
            }
            try {
                String biosText;
                try {
                    InputStreamReader isr;
                    try {
                        isr = new InputStreamReader(bios, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        isr = new InputStreamReader(bios);
                    }
                    BufferedReader reader = new BufferedReader(isr);
                    StringBuilder fileText = new StringBuilder("");
                    String line = reader.readLine();
                    while (line != null) {
                        fileText.append(line);
                        line = reader.readLine();
                        if (line == null) continue;
                        fileText.append("\n");
                    }
                    biosText = fileText.toString();
                }
                catch (IOException e) {
                    throw new LuaError("Could not read file");
                }
                LuaValue program = this.m_assert.call(this.m_loadString.call(this.toValue(biosText), this.toValue("bios.lua")));
                this.m_mainRoutine = this.m_coroutine_create.call(program);
            }
            catch (LuaError e) {
                ComputerCraft.log.warn("Could not load bios.lua ", (Throwable)e);
                if (this.m_mainRoutine == null) break block8;
                ((LuaThread)this.m_mainRoutine).abandon();
                this.m_mainRoutine = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(String eventName, Object[] arguments) {
        if (this.m_mainRoutine == null) {
            return;
        }
        if (this.m_eventFilter != null && eventName != null && !eventName.equals(this.m_eventFilter) && !eventName.equals("terminate")) {
            return;
        }
        try {
            LuaValue[] resumeArgs;
            if (eventName != null) {
                resumeArgs = this.toValues(arguments, 2);
                resumeArgs[0] = this.m_mainRoutine;
                resumeArgs[1] = this.toValue(eventName);
            } else {
                resumeArgs = new LuaValue[]{this.m_mainRoutine};
            }
            Varargs results = this.m_coroutine_resume.invoke(LuaValue.varargsOf(resumeArgs));
            if (this.m_hardAbortMessage != null) {
                throw new LuaError(this.m_hardAbortMessage);
            }
            if (!results.arg1().checkboolean()) {
                throw new LuaError(results.arg(2).checkstring().toString());
            }
            LuaValue filter = results.arg(2);
            this.m_eventFilter = filter.isstring() ? filter.toString() : null;
            LuaThread mainThread = (LuaThread)this.m_mainRoutine;
            if (mainThread.getStatus().equals("dead")) {
                this.m_mainRoutine = null;
            }
        }
        catch (LuaError e) {
            ((LuaThread)this.m_mainRoutine).abandon();
            this.m_mainRoutine = null;
        }
        finally {
            this.m_softAbortMessage = null;
            this.m_hardAbortMessage = null;
        }
    }

    @Override
    public void softAbort(String abortMessage) {
        this.m_softAbortMessage = abortMessage;
    }

    @Override
    public void hardAbort(String abortMessage) {
        this.m_softAbortMessage = abortMessage;
        this.m_hardAbortMessage = abortMessage;
    }

    @Override
    public boolean saveState(OutputStream output) {
        return false;
    }

    @Override
    public boolean restoreState(InputStream input) {
        return false;
    }

    @Override
    public boolean isFinished() {
        return this.m_mainRoutine == null;
    }

    @Override
    public void unload() {
        if (this.m_mainRoutine != null) {
            LuaThread mainThread = (LuaThread)this.m_mainRoutine;
            mainThread.abandon();
            this.m_mainRoutine = null;
        }
    }

    private void tryAbort() throws LuaError {
        String abortMessage = this.m_softAbortMessage;
        if (abortMessage != null) {
            this.m_softAbortMessage = null;
            this.m_hardAbortMessage = null;
            throw new LuaError(abortMessage);
        }
    }

    private LuaTable wrapLuaObject(ILuaObject object) {
        LuaTable table = new LuaTable();
        String[] methods = object.getMethodNames();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i] == null) continue;
            final int method = i;
            final ILuaObject apiObject = object;
            final String methodName = methods[i];
            table.set(methodName, (LuaValue)new VarArgFunction(){

                @Override
                public Varargs invoke(Varargs _args) {
                    Object[] results;
                    LuaJLuaMachine.this.tryAbort();
                    Object[] arguments = LuaJLuaMachine.this.toObjects(_args, 1);
                    try {
                        results = apiObject.callMethod(new ILuaContext(){

                            @Override
                            @Nonnull
                            public Object[] pullEvent(String filter) throws LuaException, InterruptedException {
                                Object[] results = this.pullEventRaw(filter);
                                if (results.length >= 1 && results[0].equals("terminate")) {
                                    throw new LuaException("Terminated", 0);
                                }
                                return results;
                            }

                            @Override
                            @Nonnull
                            public Object[] pullEventRaw(String filter) throws InterruptedException {
                                return this.yield(new Object[]{filter});
                            }

                            @Override
                            @Nonnull
                            public Object[] yield(Object[] yieldArgs) throws InterruptedException {
                                try {
                                    LuaValue[] yieldValues = LuaJLuaMachine.this.toValues(yieldArgs, 0);
                                    Varargs results = LuaJLuaMachine.this.m_coroutine_yield.invoke(LuaValue.varargsOf(yieldValues));
                                    return LuaJLuaMachine.this.toObjects(results, 1);
                                }
                                catch (OrphanedThread e) {
                                    throw new InterruptedException();
                                }
                            }

                            @Override
                            public long issueMainThreadTask(final @Nonnull ILuaTask task) throws LuaException {
                                final long taskID = MainThread.getUniqueTaskID();
                                ITask iTask = new ITask(){

                                    @Override
                                    public Computer getOwner() {
                                        return LuaJLuaMachine.this.m_computer;
                                    }

                                    @Override
                                    public void execute() {
                                        try {
                                            Object[] results = task.execute();
                                            if (results != null) {
                                                Object[] eventArguments = new Object[results.length + 2];
                                                eventArguments[0] = taskID;
                                                eventArguments[1] = true;
                                                System.arraycopy(results, 0, eventArguments, 2, results.length);
                                                LuaJLuaMachine.this.m_computer.queueEvent("task_complete", eventArguments);
                                            } else {
                                                LuaJLuaMachine.this.m_computer.queueEvent("task_complete", new Object[]{taskID, true});
                                            }
                                        }
                                        catch (LuaException e) {
                                            LuaJLuaMachine.this.m_computer.queueEvent("task_complete", new Object[]{taskID, false, e.getMessage()});
                                        }
                                        catch (Throwable t) {
                                            if (ComputerCraft.logPeripheralErrors) {
                                                ComputerCraft.log.error("Error running task", t);
                                            }
                                            LuaJLuaMachine.this.m_computer.queueEvent("task_complete", new Object[]{taskID, false, "Java Exception Thrown: " + t.toString()});
                                        }
                                    }
                                };
                                if (MainThread.queueTask(iTask)) {
                                    return taskID;
                                }
                                throw new LuaException("Task limit exceeded");
                            }

                            @Override
                            public Object[] executeMainThreadTask(@Nonnull ILuaTask task) throws LuaException, InterruptedException {
                                Object[] response;
                                long taskID = this.issueMainThreadTask(task);
                                while ((response = this.pullEvent("task_complete")).length < 3 || !(response[1] instanceof Number) || !(response[2] instanceof Boolean) || (long)((Number)response[1]).intValue() != taskID) {
                                }
                                Object[] returnValues = new Object[response.length - 3];
                                if (((Boolean)response[2]).booleanValue()) {
                                    System.arraycopy(response, 3, returnValues, 0, returnValues.length);
                                    return returnValues;
                                }
                                if (response.length >= 4 && response[3] instanceof String) {
                                    throw new LuaException((String)response[3]);
                                }
                                throw new LuaException();
                            }
                        }, method, arguments);
                    }
                    catch (InterruptedException e) {
                        throw new OrphanedThread();
                    }
                    catch (LuaException e) {
                        throw new LuaError(e.getMessage(), e.getLevel());
                    }
                    catch (Throwable t) {
                        if (ComputerCraft.logPeripheralErrors) {
                            ComputerCraft.log.error("Error calling " + methodName + " on " + apiObject, t);
                        }
                        throw new LuaError("Java Exception Thrown: " + t.toString(), 0);
                    }
                    return LuaValue.varargsOf(LuaJLuaMachine.this.toValues(results, 0));
                }
            });
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LuaValue toValue(Object object) {
        if (object == null) {
            return LuaValue.NIL;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return LuaValue.valueOf(d);
        }
        if (object instanceof Boolean) {
            boolean b = (Boolean)object;
            return LuaValue.valueOf(b);
        }
        if (object instanceof String) {
            String s = object.toString();
            return LuaValue.valueOf(s);
        }
        if (object instanceof byte[]) {
            byte[] b = (byte[])object;
            return LuaValue.valueOf(Arrays.copyOf(b, b.length));
        }
        if (object instanceof Map) {
            boolean clearWhenDone = false;
            try {
                if (this.m_valuesInProgress == null) {
                    this.m_valuesInProgress = new IdentityHashMap<Object, LuaValue>();
                    clearWhenDone = true;
                } else if (this.m_valuesInProgress.containsKey(object)) {
                    LuaValue luaValue = this.m_valuesInProgress.get(object);
                    return luaValue;
                }
                LuaTable table = new LuaTable();
                this.m_valuesInProgress.put(object, table);
                for (Map.Entry pair : ((Map)object).entrySet()) {
                    LuaValue key = this.toValue(pair.getKey());
                    LuaValue value = this.toValue(pair.getValue());
                    if (key.isnil() || value.isnil()) continue;
                    ((LuaValue)table).set(key, value);
                }
                LuaTable luaTable = table;
                return luaTable;
            }
            finally {
                if (clearWhenDone) {
                    this.m_valuesInProgress = null;
                }
            }
        }
        if (object instanceof ILuaObject) {
            return this.wrapLuaObject((ILuaObject)object);
        }
        return LuaValue.NIL;
    }

    private LuaValue[] toValues(Object[] objects, int leaveEmpty) {
        if (objects == null || objects.length == 0) {
            return new LuaValue[leaveEmpty];
        }
        LuaValue[] values = new LuaValue[objects.length + leaveEmpty];
        for (int i = 0; i < values.length; ++i) {
            if (i < leaveEmpty) {
                values[i] = null;
                continue;
            }
            Object object = objects[i - leaveEmpty];
            values[i] = this.toValue(object);
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object toObject(LuaValue value) {
        switch (value.type()) {
            case -1: 
            case 0: {
                return null;
            }
            case -2: 
            case 3: {
                return value.todouble();
            }
            case 1: {
                return value.toboolean();
            }
            case 4: {
                LuaString str = value.checkstring();
                return str.tojstring();
            }
            case 5: {
                boolean clearWhenDone = false;
                try {
                    Varargs keyValue;
                    if (this.m_objectsInProgress == null) {
                        this.m_objectsInProgress = new IdentityHashMap<LuaValue, Object>();
                        clearWhenDone = true;
                    } else if (this.m_objectsInProgress.containsKey(value)) {
                        Object object = this.m_objectsInProgress.get(value);
                        return object;
                    }
                    HashMap<Object, Object> table = new HashMap<Object, Object>();
                    this.m_objectsInProgress.put(value, table);
                    LuaValue k = LuaValue.NIL;
                    while (!(k = (keyValue = value.next(k)).arg1()).isnil()) {
                        LuaValue v = keyValue.arg(2);
                        Object keyObject = this.toObject(k);
                        Object valueObject = this.toObject(v);
                        if (keyObject == null || valueObject == null) continue;
                        table.put(keyObject, valueObject);
                    }
                    HashMap<Object, Object> hashMap = table;
                    return hashMap;
                }
                finally {
                    if (clearWhenDone) {
                        this.m_objectsInProgress = null;
                    }
                }
            }
        }
        return null;
    }

    private Object[] toObjects(Varargs values, int startIdx) {
        int count = values.narg();
        Object[] objects = new Object[count - startIdx + 1];
        for (int n = startIdx; n <= count; ++n) {
            int i = n - startIdx;
            LuaValue value = values.arg(n);
            objects[i] = this.toObject(value);
        }
        return objects;
    }
}

