/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import dan200.computercraft.api.filesystem.IMount;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;

public class SubMount
implements IMount {
    private IMount m_parent;
    private String m_subPath;

    public SubMount(IMount parent, String subPath) {
        this.m_parent = parent;
        this.m_subPath = subPath;
    }

    @Override
    public boolean exists(@Nonnull String path) throws IOException {
        return this.m_parent.exists(this.getFullPath(path));
    }

    @Override
    public boolean isDirectory(@Nonnull String path) throws IOException {
        return this.m_parent.isDirectory(this.getFullPath(path));
    }

    @Override
    public void list(@Nonnull String path, @Nonnull List<String> contents) throws IOException {
        this.m_parent.list(this.getFullPath(path), contents);
    }

    @Override
    public long getSize(@Nonnull String path) throws IOException {
        return this.m_parent.getSize(this.getFullPath(path));
    }

    @Override
    @Nonnull
    public InputStream openForRead(@Nonnull String path) throws IOException {
        return this.m_parent.openForRead(this.getFullPath(path));
    }

    private String getFullPath(String path) {
        if (path.length() == 0) {
            return this.m_subPath;
        }
        return this.m_subPath + "/" + path;
    }
}

