/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.handles;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.handles.HandleGeneric;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nonnull;

public class EncodedOutputHandle
extends HandleGeneric {
    private final BufferedWriter m_writer;

    public EncodedOutputHandle(BufferedWriter writer) {
        super(writer);
        this.m_writer = writer;
    }

    public EncodedOutputHandle(OutputStream stream) {
        this(stream, "UTF-8");
    }

    public EncodedOutputHandle(OutputStream stream, String encoding) {
        this(EncodedOutputHandle.makeWriter(stream, encoding));
    }

    private static BufferedWriter makeWriter(OutputStream stream, String encoding) {
        OutputStreamWriter streamWriter;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            streamWriter = new OutputStreamWriter(stream, encoding);
        }
        catch (UnsupportedEncodingException e) {
            streamWriter = new OutputStreamWriter(stream);
        }
        return new BufferedWriter(streamWriter);
    }

    @Override
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"write", "writeLine", "flush", "close"};
    }

    @Override
    public Object[] callMethod(@Nonnull ILuaContext context, int method, @Nonnull Object[] args) throws LuaException {
        switch (method) {
            case 0: {
                this.checkOpen();
                String text = args.length > 0 && args[0] != null ? args[0].toString() : "";
                try {
                    this.m_writer.write(text, 0, text.length());
                    return null;
                }
                catch (IOException e) {
                    throw new LuaException(e.getMessage());
                }
            }
            case 1: {
                this.checkOpen();
                String text = args.length > 0 && args[0] != null ? args[0].toString() : "";
                try {
                    this.m_writer.write(text, 0, text.length());
                    this.m_writer.newLine();
                    return null;
                }
                catch (IOException e) {
                    throw new LuaException(e.getMessage());
                }
            }
            case 2: {
                this.checkOpen();
                try {
                    this.m_writer.flush();
                    return null;
                }
                catch (IOException e) {
                    return null;
                }
            }
            case 3: {
                this.close();
                return null;
            }
        }
        return null;
    }
}

