/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.ILuaAPI;
import dan200.computercraft.shared.util.StringUtil;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nonnull;

public class OSAPI
implements ILuaAPI {
    private IAPIEnvironment m_apiEnvironment;
    private final Map<Integer, Timer> m_timers;
    private final Map<Integer, Alarm> m_alarms;
    private int m_clock;
    private double m_time;
    private int m_day;
    private int m_nextTimerToken;
    private int m_nextAlarmToken;

    public OSAPI(IAPIEnvironment environment) {
        this.m_apiEnvironment = environment;
        this.m_nextTimerToken = 0;
        this.m_nextAlarmToken = 0;
        this.m_timers = new HashMap<Integer, Timer>();
        this.m_alarms = new HashMap<Integer, Alarm>();
    }

    @Override
    public String[] getNames() {
        return new String[]{"os"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup() {
        this.m_time = this.m_apiEnvironment.getComputerEnvironment().getTimeOfDay();
        this.m_day = this.m_apiEnvironment.getComputerEnvironment().getDay();
        this.m_clock = 0;
        Map<Integer, Object> map = this.m_timers;
        synchronized (map) {
            this.m_timers.clear();
        }
        map = this.m_alarms;
        synchronized (map) {
            this.m_alarms.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void advance(double dt) {
        Map<Integer, Object> map = this.m_timers;
        synchronized (map) {
            ++this.m_clock;
            Iterator<Map.Entry<Integer, Timer>> it = this.m_timers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, Timer> entry = it.next();
                Timer timer = entry.getValue();
                --timer.m_ticksLeft;
                if (timer.m_ticksLeft > 0) continue;
                this.queueLuaEvent("timer", new Object[]{entry.getKey()});
                it.remove();
            }
        }
        map = this.m_alarms;
        synchronized (map) {
            double previousTime = this.m_time;
            int previousDay = this.m_day;
            double time = this.m_apiEnvironment.getComputerEnvironment().getTimeOfDay();
            int day = this.m_apiEnvironment.getComputerEnvironment().getDay();
            if (time > previousTime || day > previousDay) {
                double now = (double)this.m_day * 24.0 + this.m_time;
                Iterator<Map.Entry<Integer, Alarm>> it = this.m_alarms.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Integer, Alarm> entry = it.next();
                    Alarm alarm = entry.getValue();
                    double t = (double)alarm.m_day * 24.0 + alarm.m_time;
                    if (!(now >= t)) continue;
                    this.queueLuaEvent("alarm", new Object[]{entry.getKey()});
                    it.remove();
                }
            }
            this.m_time = time;
            this.m_day = day;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Map<Integer, Object> map = this.m_timers;
        synchronized (map) {
            this.m_timers.clear();
        }
        map = this.m_alarms;
        synchronized (map) {
            this.m_alarms.clear();
        }
    }

    @Override
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"queueEvent", "startTimer", "setAlarm", "shutdown", "reboot", "computerID", "getComputerID", "setComputerLabel", "computerLabel", "getComputerLabel", "clock", "time", "day", "cancelTimer", "cancelAlarm", "epoch"};
    }

    private float getTimeForCalendar(Calendar c) {
        float time = c.get(11);
        time += (float)c.get(12) / 60.0f;
        return time += (float)c.get(13) / 3600.0f;
    }

    private int getDayForCalendar(Calendar c) {
        GregorianCalendar g = c instanceof GregorianCalendar ? (GregorianCalendar)c : new GregorianCalendar();
        int year = c.get(1);
        int day = 0;
        for (int y = 1970; y < year; ++y) {
            day += g.isLeapYear(y) ? 366 : 365;
        }
        return day += c.get(6);
    }

    private long getEpochForCalendar(Calendar c) {
        return c.getTime().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] callMethod(@Nonnull ILuaContext context, int method, @Nonnull Object[] args) throws LuaException {
        switch (method) {
            case 0: {
                this.queueLuaEvent(ArgumentHelper.getString(args, 0), this.trimArray(args, 1));
                return null;
            }
            case 1: {
                double timer = ArgumentHelper.getReal(args, 0);
                Map<Integer, Timer> map = this.m_timers;
                synchronized (map) {
                    this.m_timers.put(this.m_nextTimerToken, new Timer((int)Math.round(timer / 0.05)));
                    return new Object[]{this.m_nextTimerToken++};
                }
            }
            case 2: {
                double time = ArgumentHelper.getReal(args, 0);
                if (time < 0.0 || time >= 24.0) {
                    throw new LuaException("Number out of range");
                }
                Map<Integer, Alarm> map = this.m_alarms;
                synchronized (map) {
                    int day = time > this.m_time ? this.m_day : this.m_day + 1;
                    this.m_alarms.put(this.m_nextAlarmToken, new Alarm(time, day));
                    return new Object[]{this.m_nextAlarmToken++};
                }
            }
            case 3: {
                this.m_apiEnvironment.shutdown();
                return null;
            }
            case 4: {
                this.m_apiEnvironment.reboot();
                return null;
            }
            case 5: 
            case 6: {
                return new Object[]{this.getComputerID()};
            }
            case 7: {
                String label = ArgumentHelper.optString(args, 0, null);
                this.m_apiEnvironment.setLabel(StringUtil.normaliseLabel(label));
                return null;
            }
            case 8: 
            case 9: {
                String label = this.m_apiEnvironment.getLabel();
                if (label != null) {
                    return new Object[]{label};
                }
                return null;
            }
            case 10: {
                Map<Integer, Timer> label = this.m_timers;
                synchronized (label) {
                    return new Object[]{(double)this.m_clock * 0.05};
                }
            }
            case 11: {
                String param;
                switch (param = ArgumentHelper.optString(args, 0, "ingame")) {
                    case "utc": {
                        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                        return new Object[]{Float.valueOf(this.getTimeForCalendar(c))};
                    }
                    case "local": {
                        Calendar c = Calendar.getInstance();
                        return new Object[]{Float.valueOf(this.getTimeForCalendar(c))};
                    }
                    case "ingame": {
                        Map<Integer, Alarm> c = this.m_alarms;
                        synchronized (c) {
                            return new Object[]{this.m_time};
                        }
                    }
                }
                throw new LuaException("Unsupported operation");
            }
            case 12: {
                String param;
                switch (param = ArgumentHelper.optString(args, 0, "ingame")) {
                    case "utc": {
                        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                        return new Object[]{this.getDayForCalendar(c)};
                    }
                    case "local": {
                        Calendar c = Calendar.getInstance();
                        return new Object[]{this.getDayForCalendar(c)};
                    }
                    case "ingame": {
                        Map<Integer, Alarm> c = this.m_alarms;
                        synchronized (c) {
                            return new Object[]{this.m_day};
                        }
                    }
                }
                throw new LuaException("Unsupported operation");
            }
            case 13: {
                int token = ArgumentHelper.getInt(args, 0);
                Map<Integer, Timer> map = this.m_timers;
                synchronized (map) {
                    if (this.m_timers.containsKey(token)) {
                        this.m_timers.remove(token);
                    }
                }
                return null;
            }
            case 14: {
                int token = ArgumentHelper.getInt(args, 0);
                Map<Integer, Alarm> map = this.m_alarms;
                synchronized (map) {
                    if (this.m_alarms.containsKey(token)) {
                        this.m_alarms.remove(token);
                    }
                }
                return null;
            }
            case 15: {
                String param;
                switch (param = ArgumentHelper.optString(args, 0, "ingame")) {
                    case "utc": {
                        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                        return new Object[]{this.getEpochForCalendar(c)};
                    }
                    case "local": {
                        Calendar c = Calendar.getInstance();
                        return new Object[]{this.getEpochForCalendar(c)};
                    }
                    case "ingame": {
                        Map<Integer, Alarm> map = this.m_alarms;
                        synchronized (map) {
                            return new Object[]{this.m_day * 86400000 + (int)(this.m_time * 3600000.0)};
                        }
                    }
                }
                throw new LuaException("Unsupported operation");
            }
        }
        return null;
    }

    private void queueLuaEvent(String event, Object[] args) {
        this.m_apiEnvironment.queueEvent(event, args);
    }

    private Object[] trimArray(Object[] array, int skip) {
        return Arrays.copyOfRange(array, skip, array.length);
    }

    private int getComputerID() {
        return this.m_apiEnvironment.getComputerID();
    }

    private class Alarm
    implements Comparable<Alarm> {
        public final double m_time;
        public final int m_day;

        public Alarm(double time, int day) {
            this.m_time = time;
            this.m_day = day;
        }

        @Override
        public int compareTo(@Nonnull Alarm o) {
            double t = (double)this.m_day * 24.0 + this.m_time;
            double ot = (double)this.m_day * 24.0 + this.m_time;
            if (t < ot) {
                return -1;
            }
            if (t > ot) {
                return 1;
            }
            return 0;
        }
    }

    private static class Timer {
        public int m_ticksLeft;

        public Timer(int ticksLeft) {
            this.m_ticksLeft = ticksLeft;
        }
    }
}

