/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.ILuaAPI;
import dan200.computercraft.core.terminal.TextBuffer;
import javax.annotation.Nonnull;

public class BufferAPI
implements ILuaAPI {
    public BufferAPI(IAPIEnvironment _env) {
    }

    @Override
    public String[] getNames() {
        return new String[]{"buffer"};
    }

    @Override
    public void startup() {
    }

    @Override
    public void advance(double _dt) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"new"};
    }

    @Override
    public Object[] callMethod(@Nonnull ILuaContext context, int method, @Nonnull Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                String text = ArgumentHelper.getString(arguments, 0);
                int repetitions = ArgumentHelper.optInt(arguments, 1, 1);
                if (repetitions < 0) {
                    throw ArgumentHelper.badArgument(1, "positive number", Integer.toString(repetitions));
                }
                TextBuffer buffer = new TextBuffer(text, repetitions);
                return new Object[]{new BufferLuaObject(buffer)};
            }
        }
        return null;
    }

    private static class BufferLuaObject
    implements ILuaObject {
        private TextBuffer m_buffer;

        public BufferLuaObject(TextBuffer buffer) {
            this.m_buffer = buffer;
        }

        @Override
        @Nonnull
        public String[] getMethodNames() {
            return new String[]{"len", "tostring", "read", "write", "fill"};
        }

        @Override
        public Object[] callMethod(@Nonnull ILuaContext context, int method, @Nonnull Object[] arguments) throws LuaException, InterruptedException {
            switch (method) {
                case 0: {
                    return new Object[]{this.m_buffer.length()};
                }
                case 1: {
                    return new Object[]{this.m_buffer.toString()};
                }
                case 2: {
                    int start = ArgumentHelper.optInt(arguments, 0, 0);
                    int end = ArgumentHelper.optInt(arguments, 1, this.m_buffer.length());
                    return new Object[]{this.m_buffer.read(start, end)};
                }
                case 3: {
                    String text = ArgumentHelper.getString(arguments, 0);
                    int start = ArgumentHelper.optInt(arguments, 1, 0);
                    int end = ArgumentHelper.optInt(arguments, 2, start + text.length());
                    this.m_buffer.write(text, start, end);
                    return null;
                }
                case 4: {
                    String text = ArgumentHelper.getString(arguments, 0);
                    int start = ArgumentHelper.optInt(arguments, 1, 0);
                    int end = ArgumentHelper.optInt(arguments, 2, this.m_buffer.length());
                    this.m_buffer.fill(text, start, end);
                    return null;
                }
            }
            return null;
        }
    }
}

