/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.LuaException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ArgumentHelper {
    private ArgumentHelper() {
        throw new IllegalStateException("Cannot instantiate singleton " + this.getClass().getName());
    }

    @Nonnull
    public static String getType(@Nullable Object type) {
        if (type == null) {
            return "nil";
        }
        if (type instanceof String) {
            return "string";
        }
        if (type instanceof Boolean) {
            return "boolean";
        }
        if (type instanceof Number) {
            return "number";
        }
        if (type instanceof Map) {
            return "table";
        }
        Class<?> klass = type.getClass();
        if (klass.isArray()) {
            StringBuilder name = new StringBuilder();
            while (klass.isArray()) {
                name.append("[]");
                klass = klass.getComponentType();
            }
            name.insert(0, klass.getName());
            return name.toString();
        }
        return klass.getName();
    }

    @Nonnull
    public static LuaException badArgument(int index, @Nonnull String expected, @Nullable Object actual) {
        return ArgumentHelper.badArgument(index, expected, ArgumentHelper.getType(actual));
    }

    @Nonnull
    public static LuaException badArgument(int index, @Nonnull String expected, @Nonnull String actual) {
        return new LuaException("bad argument #" + (index + 1) + " (" + expected + " expected, got " + actual + ")");
    }

    public static double getNumber(@Nonnull Object[] args, int index) throws LuaException {
        if (index >= args.length) {
            throw ArgumentHelper.badArgument(index, "number", "nil");
        }
        Object value = args[index];
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw ArgumentHelper.badArgument(index, "number", value);
    }

    public static int getInt(@Nonnull Object[] args, int index) throws LuaException {
        if (index >= args.length) {
            throw ArgumentHelper.badArgument(index, "number", "nil");
        }
        Object value = args[index];
        if (value instanceof Number) {
            return (int)((Number)value).longValue();
        }
        throw ArgumentHelper.badArgument(index, "number", value);
    }

    public static double getReal(@Nonnull Object[] args, int index) throws LuaException {
        return ArgumentHelper.checkReal(index, ArgumentHelper.getNumber(args, index));
    }

    public static boolean getBoolean(@Nonnull Object[] args, int index) throws LuaException {
        if (index >= args.length) {
            throw ArgumentHelper.badArgument(index, "boolean", "nil");
        }
        Object value = args[index];
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw ArgumentHelper.badArgument(index, "boolean", value);
    }

    @Nonnull
    public static String getString(@Nonnull Object[] args, int index) throws LuaException {
        if (index >= args.length) {
            throw ArgumentHelper.badArgument(index, "string", "nil");
        }
        Object value = args[index];
        if (value instanceof String) {
            return (String)value;
        }
        throw ArgumentHelper.badArgument(index, "string", value);
    }

    @Nonnull
    public static Map<Object, Object> getTable(@Nonnull Object[] args, int index) throws LuaException {
        if (index >= args.length) {
            throw ArgumentHelper.badArgument(index, "table", "nil");
        }
        Object value = args[index];
        if (value instanceof Map) {
            return (Map)value;
        }
        throw ArgumentHelper.badArgument(index, "table", value);
    }

    public static double optNumber(@Nonnull Object[] args, int index, double def) throws LuaException {
        Object value;
        Object object = value = index < args.length ? args[index] : null;
        if (value == null) {
            return def;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw ArgumentHelper.badArgument(index, "number", value);
    }

    public static int optInt(@Nonnull Object[] args, int index, int def) throws LuaException {
        Object value;
        Object object = value = index < args.length ? args[index] : null;
        if (value == null) {
            return def;
        }
        if (value instanceof Number) {
            return (int)((Number)value).longValue();
        }
        throw ArgumentHelper.badArgument(index, "number", value);
    }

    public static double optReal(@Nonnull Object[] args, int index, double def) throws LuaException {
        return ArgumentHelper.checkReal(index, ArgumentHelper.optNumber(args, index, def));
    }

    public static boolean optBoolean(@Nonnull Object[] args, int index, boolean def) throws LuaException {
        Object value;
        Object object = value = index < args.length ? args[index] : null;
        if (value == null) {
            return def;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw ArgumentHelper.badArgument(index, "boolean", value);
    }

    public static String optString(@Nonnull Object[] args, int index, String def) throws LuaException {
        Object value;
        Object object = value = index < args.length ? args[index] : null;
        if (value == null) {
            return def;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw ArgumentHelper.badArgument(index, "string", value);
    }

    public static Map<Object, Object> optTable(@Nonnull Object[] args, int index, Map<Object, Object> def) throws LuaException {
        Object value;
        Object object = value = index < args.length ? args[index] : null;
        if (value == null) {
            return def;
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw ArgumentHelper.badArgument(index, "table", value);
    }

    private static double checkReal(int index, double value) throws LuaException {
        if (Double.isNaN(value)) {
            throw ArgumentHelper.badArgument(index, "number", "nan");
        }
        if (value == Double.POSITIVE_INFINITY) {
            throw ArgumentHelper.badArgument(index, "number", "inf");
        }
        if (value == Double.NEGATIVE_INFINITY) {
            throw ArgumentHelper.badArgument(index, "number", "-inf");
        }
        return value;
    }
}

