/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.turtle;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TurtleCommandResult {
    private static final TurtleCommandResult s_success = new TurtleCommandResult(true, null, null);
    private static final TurtleCommandResult s_emptyFailure = new TurtleCommandResult(false, null, null);
    private final boolean m_success;
    private final String m_errorMessage;
    private final Object[] m_results;

    @Nonnull
    public static TurtleCommandResult success() {
        return TurtleCommandResult.success(null);
    }

    @Nonnull
    public static TurtleCommandResult success(@Nullable Object[] results) {
        if (results == null || results.length == 0) {
            return s_success;
        }
        return new TurtleCommandResult(true, null, results);
    }

    @Nonnull
    public static TurtleCommandResult failure() {
        return TurtleCommandResult.failure(null);
    }

    @Nonnull
    public static TurtleCommandResult failure(@Nullable String errorMessage) {
        if (errorMessage == null) {
            return s_emptyFailure;
        }
        return new TurtleCommandResult(false, errorMessage, null);
    }

    private TurtleCommandResult(boolean success, String errorMessage, Object[] results) {
        this.m_success = success;
        this.m_errorMessage = errorMessage;
        this.m_results = results;
    }

    public boolean isSuccess() {
        return this.m_success;
    }

    @Nullable
    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    @Nullable
    public Object[] getResults() {
        return this.m_results;
    }
}

