/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.spawner.creative;

import com.enderio.core.common.ContainerEnderCap;
import com.enderio.core.common.inventory.EnderInventory;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.machine.base.block.AbstractCapabilityMachineBlock;
import crazypants.enderio.base.machine.render.RenderMappers;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.machines.machine.spawner.creative.ContainerCreativeSpawner;
import crazypants.enderio.machines.machine.spawner.creative.ContainerCreativeSpawnerUser;
import crazypants.enderio.machines.machine.spawner.creative.GuiCreativeSpawner;
import crazypants.enderio.machines.machine.spawner.creative.TileCreativeSpawner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

public class BlockCreativeSpawner
extends AbstractCapabilityMachineBlock<TileCreativeSpawner>
implements IPaintable.ISolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    @Nonnull
    private static String permissionGUI = "(container not initialized)";

    public static BlockCreativeSpawner create(@Nonnull IModObject modObject) {
        BlockCreativeSpawner res = new BlockCreativeSpawner(modObject);
        res.init();
        return res;
    }

    protected BlockCreativeSpawner(@Nonnull IModObject modObject) {
        super(modObject);
        this.setShape(this.mkShape(BlockFaceShape.SOLID));
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
    }

    @Override
    public void init(@Nonnull IModObject modObject, @Nonnull FMLInitializationEvent event) {
        permissionGUI = PermissionAPI.registerNode((String)"enderio.creative_spawner.edit", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Permission to edit the creative spawner's settings.");
        this.permissionNodeWrenching = PermissionAPI.registerNode((String)("enderio.wrench.break." + modObject.getUnlocalisedName()), (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)("Permission to wrench-break the block " + modObject.getUnlocalisedName() + " of Ender IO"));
        this.permissionNodeIOWrenching = PermissionAPI.registerNode((String)("enderio.wrench.iomode." + modObject.getUnlocalisedName()), (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)("Permission to set IO mode by wrench-clicking the block " + modObject.getUnlocalisedName() + " of Ender IO"));
    }

    @Override
    protected boolean openGui(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumFacing side) {
        TileCreativeSpawner te;
        boolean hasPermission = PermissionAPI.hasPermission((EntityPlayer)entityPlayer, (String)permissionGUI);
        if (!hasPermission && (te = (TileCreativeSpawner)this.getTileEntity((IBlockAccess)world, pos)) != null && te.isActive()) {
            return false;
        }
        return this.openGui(world, pos, entityPlayer, side, hasPermission ? 0 : 1);
    }

    @Nonnull
    public ContainerEnderCap<EnderInventory, TileCreativeSpawner> getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TileCreativeSpawner te) {
        return param1 == 0 ? new ContainerCreativeSpawner(player.field_71071_by, te) : new ContainerCreativeSpawnerUser(player.field_71071_by, te);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TileCreativeSpawner te) {
        return new GuiCreativeSpawner(player.field_71071_by, te, this.getServerGuiElement(player, world, pos, facing, param1, te));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMappers.FRONT_MAPPER_NO_IO;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return RenderMappers.FRONT_MAPPER_NO_IO;
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileCreativeSpawner tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.getFacing());
    }

    public boolean canEntityDestroy(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        return false;
    }
}

