/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.sagmill;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.machines.machine.sagmill.TileSagMill;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGrindingBall
extends MessageTileEntity<TileSagMill>
implements IMessage {
    int currGbUse;
    int maxGbUse;

    public PacketGrindingBall() {
    }

    public PacketGrindingBall(@Nonnull TileSagMill ent) {
        super((TileEntity)ent);
        this.currGbUse = ent.grindingBallDurabilityUsed;
        this.maxGbUse = ent.grindingBall == null ? 0 : ent.grindingBall.getDurability();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.currGbUse);
        buf.writeInt(this.maxGbUse);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.currGbUse = buf.readInt();
        this.maxGbUse = buf.readInt();
    }

    public static class Handler
    implements IMessageHandler<PacketGrindingBall, IMessage> {
        public IMessage onMessage(PacketGrindingBall message, MessageContext ctx) {
            EntityPlayer player = EnderIO.proxy.getClientPlayer();
            TileSagMill te = (TileSagMill)message.getTileEntity(player.field_70170_p);
            if (te != null) {
                te.grindingBallDurabilityUsed = message.currGbUse;
                te.grindingBallDurabilityMax = message.maxGbUse;
            }
            return null;
        }
    }
}

