/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.handler.darksteel.StateController;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketUpgradeState
implements IMessage {
    private int entityID;
    @Nonnull
    private final Map<String, Boolean> payload = new HashMap<String, Boolean>();

    public PacketUpgradeState() {
    }

    public PacketUpgradeState(@Nonnull String type, boolean isActive) {
        this(type, isActive, 0);
    }

    public PacketUpgradeState(@Nonnull String type, boolean isActive, int entityID) {
        this.entityID = entityID;
        this.add(type, isActive);
    }

    public PacketUpgradeState(int entityID) {
        this.entityID = entityID;
    }

    public void add(@Nonnull String type, boolean isActive) {
        this.payload.put(type, isActive);
    }

    public void toBytes(ByteBuf buf) {
        if (buf != null) {
            buf.writeInt(this.entityID);
            buf.writeInt(this.payload.size());
            for (Map.Entry<String, Boolean> pair : this.payload.entrySet()) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)pair.getKey());
                buf.writeBoolean(pair.getValue().booleanValue());
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        if (buf != null) {
            this.entityID = buf.readInt();
            int count = buf.readInt();
            for (int i = 0; i < count; ++i) {
                this.payload.put(ByteBufUtils.readUTF8String((ByteBuf)buf), buf.readBoolean());
            }
        }
    }

    public static class ServerHandler
    implements IMessageHandler<PacketUpgradeState, IMessage> {
        public IMessage onMessage(PacketUpgradeState message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            for (Map.Entry pair : message.payload.entrySet()) {
                StateController.setActive((EntityPlayer)player, (String)NullHelper.first((Object[])new String[]{(String)pair.getKey(), ""}), (boolean)((Boolean)pair.getValue()));
            }
            return null;
        }
    }

    public static class ClientHandler
    implements IMessageHandler<PacketUpgradeState, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketUpgradeState message, MessageContext ctx) {
            Entity player = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityID);
            if (player instanceof EntityPlayer) {
                for (Map.Entry pair : message.payload.entrySet()) {
                    StateController.syncActive((EntityPlayer)player, (String)NullHelper.first((Object[])new String[]{(String)pair.getKey(), ""}), (Boolean)pair.getValue());
                }
            }
            return null;
        }
    }
}

