/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.redstone;

import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.conduit.redstone.signals.BundledSignal;
import crazypants.enderio.base.conduit.redstone.signals.CombinedSignal;
import crazypants.enderio.base.conduit.redstone.signals.Signal;
import crazypants.enderio.base.filter.redstone.ILogicSignalFilterType;
import crazypants.enderio.base.filter.redstone.IOutputSignalFilter;
import crazypants.enderio.base.lang.ILang;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.util.EnumReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class LogicOutputSignalFilter
implements IOutputSignalFilter {
    @Nonnull
    private static final String NBT_SIGNAL_COLORS = "signalColors";
    @Nonnull
    private static final String NBT_COLOR = "color";
    @Nonnull
    private static final String NBT_TYPE = "type";
    @Nonnull
    private static final String NBT_FILTER_TYPE = "filterType";
    @Nonnull
    private final List<DyeColor> signalColors;
    @Nonnull
    private EnumSignalFilterType type;

    @Nonnull
    protected static CombinedSignal invertSignal(CombinedSignal sig) {
        return sig.getStrength() > 0 ? CombinedSignal.NONE : CombinedSignal.MAX;
    }

    public LogicOutputSignalFilter() {
        this(EnumSignalFilterType.OR);
    }

    public LogicOutputSignalFilter(@Nonnull EnumSignalFilterType type) {
        this.type = type;
        this.signalColors = new ArrayList<DyeColor>(type.getNumButtons());
        for (int i = 0; i < type.getNumButtons(); ++i) {
            this.signalColors.add(DyeColor.fromIndex((int)i));
        }
    }

    public void setColor(int index, @Nonnull DyeColor color) {
        if (index < this.signalColors.size()) {
            this.signalColors.set(index, color);
        }
    }

    public int getNumColors() {
        return this.signalColors.size();
    }

    @Nonnull
    public DyeColor getColor(int index) {
        if (index < this.signalColors.size()) {
            return (DyeColor)NullHelper.first((Object[])new DyeColor[]{this.signalColors.get(index), DyeColor.fromIndex((int)0)});
        }
        return DyeColor.fromIndex((int)0);
    }

    @Nonnull
    public List<DyeColor> getSignalColors() {
        return this.signalColors;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        this.signalColors.clear();
        NBTTagCompound t = nbtRoot.func_74775_l(NBT_FILTER_TYPE);
        this.type = EnumReader.get(EnumSignalFilterType.class, t.func_74762_e(NBT_TYPE));
        NBTTagList tagList = nbtRoot.func_150295_c(NBT_SIGNAL_COLORS, (int)nbtRoot.func_74732_a());
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            this.signalColors.add(DyeColor.fromIndex((int)tagList.func_150305_b(i).func_74762_e(NBT_COLOR)));
        }
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        NBTTagList colorList = new NBTTagList();
        int index = 0;
        for (DyeColor color : this.signalColors) {
            NBTTagCompound root = new NBTTagCompound();
            if (color != null) {
                root.func_74768_a("index", index);
                root.func_74768_a(NBT_COLOR, color.ordinal());
                colorList.func_74742_a((NBTBase)root);
            }
            ++index;
        }
        NBTTagCompound t = new NBTTagCompound();
        t.func_74768_a(NBT_TYPE, this.type.ordinal());
        nbtRoot.func_74782_a(NBT_FILTER_TYPE, (NBTBase)t);
        nbtRoot.func_74782_a(NBT_SIGNAL_COLORS, (NBTBase)colorList);
    }

    @Override
    @Nonnull
    public CombinedSignal apply(@Nonnull DyeColor color, @Nonnull BundledSignal bundledSignal) {
        return this.type.apply(bundledSignal, this.getSignalColors());
    }

    @Nonnull
    public String getHeading() {
        return this.type.getHeading();
    }

    public static enum EnumSignalFilterType implements ILogicSignalFilterType
    {
        OR(2, Lang.GUI_REDSTONE_FILTER_OR){

            @Override
            @Nonnull
            public CombinedSignal apply(@Nonnull BundledSignal bundledSignal, @Nonnull List<DyeColor> signalColors) {
                for (DyeColor sigColor : signalColors) {
                    if (sigColor == null || bundledSignal.getSignal(sigColor).getStrength() <= Signal.NONE.getStrength()) continue;
                    return CombinedSignal.MAX;
                }
                return CombinedSignal.NONE;
            }
        }
        ,
        AND(2, Lang.GUI_REDSTONE_FILTER_AND){

            @Override
            @Nonnull
            public CombinedSignal apply(@Nonnull BundledSignal bundledSignal, @Nonnull List<DyeColor> signalColors) {
                for (DyeColor sigColor : signalColors) {
                    if (sigColor == null || bundledSignal.getSignal(sigColor).getStrength() > Signal.NONE.getStrength()) continue;
                    return CombinedSignal.NONE;
                }
                return CombinedSignal.MAX;
            }
        }
        ,
        NAND(2, Lang.GUI_REDSTONE_FILTER_NAND){

            @Override
            @Nonnull
            public CombinedSignal apply(@Nonnull BundledSignal bundledSignal, @Nonnull List<DyeColor> signalColors) {
                return LogicOutputSignalFilter.invertSignal(AND.apply(bundledSignal, signalColors));
            }
        }
        ,
        NOR(2, Lang.GUI_REDSTONE_FILTER_NOR){

            @Override
            @Nonnull
            public CombinedSignal apply(@Nonnull BundledSignal bundledSignal, @Nonnull List<DyeColor> signalColors) {
                return LogicOutputSignalFilter.invertSignal(OR.apply(bundledSignal, signalColors));
            }
        }
        ,
        XOR(2, Lang.GUI_REDSTONE_FILTER_XOR){

            @Override
            @Nonnull
            public CombinedSignal apply(@Nonnull BundledSignal bundledSignal, @Nonnull List<DyeColor> signalColors) {
                boolean output = false;
                for (DyeColor sigColor : signalColors) {
                    if (sigColor == null || bundledSignal.getSignal(sigColor).getStrength() <= Signal.NONE.getStrength()) continue;
                    output = !output;
                }
                return output ? CombinedSignal.MAX : CombinedSignal.NONE;
            }
        }
        ,
        XNOR(2, Lang.GUI_REDSTONE_FILTER_XNOR){

            @Override
            @Nonnull
            public CombinedSignal apply(@Nonnull BundledSignal bundledSignal, @Nonnull List<DyeColor> signalColors) {
                return LogicOutputSignalFilter.invertSignal(XOR.apply(bundledSignal, signalColors));
            }
        };

        private final int numButtons;
        private final ILang headingLang;

        private EnumSignalFilterType(int numButtons, ILang headingLang) {
            this.numButtons = numButtons;
            this.headingLang = headingLang;
        }

        @Override
        public int getNumButtons() {
            return this.numButtons;
        }

        @Override
        @Nonnull
        public String getHeading() {
            return this.headingLang.get();
        }
    }
}

