/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.recipes.IRecipeConfigElement;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.util.CapturedMob;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.util.ResourceLocation;

public class Soul
implements IRecipeConfigElement {
    protected Optional<String> name = this.empty();
    protected transient Optional<CapturedMob> mob = this.empty();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        if (!this.name.isPresent()) {
            this.mob = this.empty();
            return this;
        }
        this.mob = this.ofNullable(CapturedMob.create(new ResourceLocation(this.get(this.name))));
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        if (!this.isValid()) {
            Log.warn("Could not find an entity for '" + this.name.get() + "'");
            Log.warn("Available entities are:");
            for (CapturedMob possible : CapturedMob.getAllSouls()) {
                Log.warn(" -> " + possible.getEntityName() + " (" + possible.getDisplayName() + ")");
            }
            throw new InvalidRecipeConfigException("Could not find an entity for '" + this.name.get() + "'");
        }
    }

    @Override
    public boolean isValid() {
        return this.mob.isPresent();
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("name".equals(name)) {
            this.name = this.ofString(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }

    public CapturedMob getMob() {
        return this.get(this.mob);
    }
}

