/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.capability;

import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.machine.baselegacy.AbstractInventoryMachineEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;

public class LegacyMachineWrapper
implements IItemHandler {
    @Nonnull
    protected final AbstractInventoryMachineEntity machine;
    @Nonnull
    protected final EnumFacing side;
    protected IoMode lastIoMode = null;
    @Nonnull
    protected final NNList<Integer> slots = new NNList();

    public LegacyMachineWrapper(@Nonnull AbstractInventoryMachineEntity machine, @Nonnull EnumFacing side) {
        this.machine = machine;
        this.side = side;
    }

    protected void computeSlotMappings() {
        IoMode ioMode = this.machine.getIoMode(this.side);
        if (ioMode != this.lastIoMode) {
            this.slots.clear();
            SlotDefinition slotDefinition = this.machine.getSlotDefinition();
            for (int i = 0; i < slotDefinition.getNumSlots(); ++i) {
                if ((!ioMode.canRecieveInput() || !slotDefinition.isInputSlot(i)) && (!ioMode.canOutput() || !slotDefinition.isOutputSlot(i))) continue;
                this.slots.add((Object)i);
            }
            this.lastIoMode = ioMode;
        }
    }

    public int getSlots() {
        this.computeSlotMappings();
        return this.slots.size();
    }

    protected int extSlot2intSlot(int external) {
        this.computeSlotMappings();
        if (external >= 0 && external < this.slots.size()) {
            return (Integer)this.slots.get(external);
        }
        return -1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.machine.getStackInSlot(this.extSlot2intSlot(slot));
    }

    @Nonnull
    public ItemStack insertItem(int external, @Nonnull ItemStack stack, boolean simulate) {
        if (Prep.isInvalid(stack) || !this.machine.getIoMode(this.side).canRecieveInput()) {
            return stack;
        }
        int slot = this.extSlot2intSlot(external);
        if (!this.machine.getSlotDefinition().isInputSlot(slot)) {
            return stack;
        }
        return this.doInsertItem(slot, stack, simulate);
    }

    @Nonnull
    protected ItemStack doInsertItem(int internal, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack existing = this.machine.getStackInSlot(internal);
        if (Prep.isValid(existing)) {
            int max = Math.min(existing.func_77976_d(), this.machine.getInventoryStackLimit(internal));
            if (existing.func_190916_E() >= max || !ItemUtil.areStackMergable((ItemStack)existing, (ItemStack)stack)) {
                return stack;
            }
            int movable = Math.min(max - existing.func_190916_E(), stack.func_190916_E());
            if (!simulate) {
                existing.func_190917_f(movable);
                this.machine.func_70296_d();
            }
            if (movable >= stack.func_190916_E()) {
                return Prep.getEmpty();
            }
            ItemStack copy = stack.func_77946_l();
            copy.func_190918_g(movable);
            return copy;
        }
        if (!this.machine.isMachineItemValidForSlot(internal, stack)) {
            return stack;
        }
        int max = Math.min(stack.func_77976_d(), this.machine.getInventoryStackLimit(internal));
        if (max >= stack.func_190916_E()) {
            if (!simulate) {
                this.machine.setInventorySlotContents(internal, stack.func_77946_l());
            }
            return Prep.getEmpty();
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(max);
        if (!simulate) {
            this.machine.setInventorySlotContents(internal, copy);
        }
        copy = stack.func_77946_l();
        copy.func_190918_g(max);
        return copy;
    }

    @Nonnull
    public ItemStack extractItem(int external, int amount, boolean simulate) {
        if (amount <= 0 || !this.machine.getIoMode(this.side).canOutput()) {
            return Prep.getEmpty();
        }
        int slot = this.extSlot2intSlot(external);
        if (!this.machine.getSlotDefinition().isOutputSlot(slot)) {
            return Prep.getEmpty();
        }
        return this.doExtractItem(slot, amount, simulate);
    }

    @Nonnull
    protected ItemStack doExtractItem(int internal, int amount, boolean simulate) {
        ItemStack existing = this.machine.getStackInSlot(internal);
        if (Prep.isInvalid(existing)) {
            return Prep.getEmpty();
        }
        int max = Math.min(amount, existing.func_190916_E());
        ItemStack copy = existing.func_77946_l();
        copy.func_190920_e(max);
        if (!simulate) {
            existing.func_190918_g(max);
            if (Prep.isInvalid(existing)) {
                this.machine.setInventorySlotContents(internal, Prep.getEmpty());
            } else {
                this.machine.func_70296_d();
            }
        }
        return copy;
    }

    public int getSlotLimit(int external) {
        int internal = this.extSlot2intSlot(external);
        return internal >= 0 ? this.machine.getInventoryStackLimit(internal) : 0;
    }
}

