/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import info.openmods.calc.Environment;
import info.openmods.calc.Frame;
import info.openmods.calc.FrameFactory;
import info.openmods.calc.executable.BinaryOperator;
import info.openmods.calc.executable.IExecutable;
import info.openmods.calc.executable.SymbolCall;
import info.openmods.calc.executable.Value;
import info.openmods.calc.parsing.ast.IParserState;
import info.openmods.calc.parsing.ast.ISymbolCallStateTransition;
import info.openmods.calc.parsing.ast.SameStateSymbolTransition;
import info.openmods.calc.parsing.node.BinaryOpNode;
import info.openmods.calc.parsing.node.IExprNode;
import info.openmods.calc.parsing.node.SymbolCallNode;
import info.openmods.calc.parsing.node.SymbolGetNode;
import info.openmods.calc.symbol.ICallable;
import info.openmods.calc.symbol.SymbolMap;
import info.openmods.calc.types.multi.Code;
import info.openmods.calc.types.multi.Cons;
import info.openmods.calc.types.multi.MetaObject;
import info.openmods.calc.types.multi.MetaObjectUtils;
import info.openmods.calc.types.multi.ScopeModifierNode;
import info.openmods.calc.types.multi.Symbol;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypeUserdata;
import info.openmods.calc.types.multi.TypedCalcUtils;
import info.openmods.calc.types.multi.TypedValue;
import info.openmods.calc.utils.OptionalInt;
import info.openmods.calc.utils.Stack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AltExpressionFactory {
    private static final String ATTR_FIELDS = "fields";
    private final TypeDomain domain;
    private final TypedValue nullValue;
    private final BinaryOperator<TypedValue> colonOperator;
    private final BinaryOperator<TypedValue> assignOperator;
    private final BinaryOperator<TypedValue> splitOperator;

    public AltExpressionFactory(TypeDomain domain, TypedValue nullValue, BinaryOperator<TypedValue> colonOperator, BinaryOperator<TypedValue> assignOperator, BinaryOperator<TypedValue> splitOperator) {
        this.domain = domain;
        this.nullValue = nullValue;
        this.colonOperator = colonOperator;
        this.assignOperator = assignOperator;
        this.splitOperator = splitOperator;
        this.domain.registerType(AltType.class, "alt_type", AltExpressionFactory.createAltTypeMetaObject());
        this.domain.registerType(AltTypeVariant.class, "alt_variant", this.createAltVariantMetaObject());
        this.domain.registerType(AltValue.class, "alt_value", AltExpressionFactory.createAltValueMetaObject());
    }

    public ISymbolCallStateTransition<IExprNode<TypedValue>> createStateTransition(IParserState<IExprNode<TypedValue>> parentState) {
        class AltStateTransition
        extends SameStateSymbolTransition<IExprNode<TypedValue>> {
            public AltStateTransition(IParserState<IExprNode<TypedValue>> parentState) {
                super(parentState);
            }

            @Override
            public IExprNode<TypedValue> createRootNode(List<IExprNode<TypedValue>> children) {
                return new AltNode(children);
            }
        }
        return new AltStateTransition(parentState);
    }

    private static MetaObject createAltTypeMetaObject() {
        return MetaObject.builder().set(new MetaObject.SlotStr(){

            @Override
            public String str(TypedValue self, Frame<TypedValue> frame) {
                return "<alt " + self.as(AltType.class) + ">";
            }
        }).set(new MetaObject.SlotRepr(){

            @Override
            public String repr(TypedValue self, Frame<TypedValue> frame) {
                return "<alt " + self.as(AltType.class) + ">";
            }
        }).set(new MetaObject.SlotAttr(){

            @Override
            public Optional<TypedValue> attr(TypedValue self, String key, Frame<TypedValue> frame) {
                return self.as(AltType.class).attr(key);
            }
        }).set(new MetaObject.SlotDir(){

            @Override
            public Iterable<String> dir(TypedValue self, Frame<TypedValue> frame) {
                return self.as(AltType.class).dir();
            }
        }).set(MetaObjectUtils.DECOMPOSE_ON_TYPE).build();
    }

    private MetaObject createAltVariantMetaObject() {
        return MetaObject.builder().set(new MetaObject.SlotDecompose(){

            @Override
            public Optional<List<TypedValue>> tryDecompose(TypedValue self, TypedValue input, int variableCount, Frame<TypedValue> frame) {
                AltValue value;
                AltTypeVariant variant = self.as(AltTypeVariant.class);
                Preconditions.checkArgument((variableCount == variant.members.size() ? 1 : 0) != 0, (String)"Invalid number of values to unpack, expected %s got %s", (int)variant.members.size(), (int)variableCount);
                if (input.is(AltValue.class) && (value = input.as(AltValue.class)).variant == variant) {
                    List values = value.values;
                    Preconditions.checkState((values.size() == variant.members.size() ? 1 : 0) != 0, (String)"Mismatched size in container: names: %s, values: %s", (Object)variant.members, (Object)values);
                    return Optional.of((Object)values);
                }
                return Optional.absent();
            }
        }).set(new MetaObject.SlotStr(){

            @Override
            public String str(TypedValue self, Frame<TypedValue> frame) {
                AltTypeVariant variant = self.as(AltTypeVariant.class);
                return "<alt " + variant.type.id + ":" + variant.id + ">";
            }
        }).set(new MetaObject.SlotRepr(){

            @Override
            public String repr(TypedValue self, Frame<TypedValue> frame) {
                AltTypeVariant variant = self.as(AltTypeVariant.class);
                return "<alt " + variant.type.id + ":" + variant.id + ">";
            }
        }).set(new MetaObject.SlotCall(){

            @Override
            public void call(TypedValue self, OptionalInt argumentsCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
                AltTypeVariant variant = self.as(AltTypeVariant.class);
                TypedCalcUtils.expectExactArgCount(argumentsCount, variant.members.size());
                TypedCalcUtils.expectSingleReturn(returnsCount);
                Stack<TypedValue> substack = frame.stack().substack(variant.members.size());
                AltValue container = new AltValue(variant, (List<TypedValue>)ImmutableList.copyOf(substack));
                substack.clear();
                substack.push(AltExpressionFactory.this.domain.create(AltValue.class, container));
            }
        }).set(new MetaObject.SlotAttr(){

            @Override
            public Optional<TypedValue> attr(TypedValue self, String key, Frame<TypedValue> frame) {
                if ("name".equals(key)) {
                    return Optional.of((Object)AltExpressionFactory.this.domain.create(String.class, self.as(AltTypeVariant.class).name));
                }
                if (AltExpressionFactory.ATTR_FIELDS.equals(key)) {
                    return Optional.of((Object)self.as(AltTypeVariant.class).membersList);
                }
                return Optional.absent();
            }
        }).set(MetaObjectUtils.dirFromArray("name", ATTR_FIELDS)).build();
    }

    private static MetaObject createAltValueMetaObject() {
        return MetaObject.builder().set(new MetaObject.SlotStr(){

            @Override
            public String str(TypedValue self, Frame<TypedValue> frame) {
                AltValue value = self.as(AltValue.class);
                ArrayList values = Lists.newArrayList();
                for (int i = 0; i < values.size(); ++i) {
                    String k = (String)value.variant.members.get(i);
                    TypedValue v = (TypedValue)value.values.get(i);
                    values.add(k + "=" + MetaObjectUtils.callStrSlot(frame, v));
                }
                return "<alt " + value.variant.type.id + ":" + value.variant.id + "(" + Joiner.on((char)',').join((Iterable)values) + ")>";
            }
        }).set(new MetaObject.SlotRepr(){

            @Override
            public String repr(TypedValue self, Frame<TypedValue> frame) {
                AltValue value = self.as(AltValue.class);
                ArrayList values = Lists.newArrayList();
                for (int i = 0; i < values.size(); ++i) {
                    String k = (String)value.variant.members.get(i);
                    TypedValue v = (TypedValue)value.values.get(i);
                    values.add(k + "=" + MetaObjectUtils.callReprSlot(frame, v));
                }
                return value.variant.type.id + "." + value.variant.id + "(" + Joiner.on((char)',').join((Iterable)values) + ")>";
            }
        }).set(new MetaObject.SlotType(){

            @Override
            public TypedValue type(TypedValue self, Frame<TypedValue> frame) {
                return self.as(AltValue.class).variant.type.selfValue;
            }
        }).set(new MetaObject.SlotAttr(){

            @Override
            public Optional<TypedValue> attr(TypedValue self, String key, Frame<TypedValue> frame) {
                AltValue value = self.as(AltValue.class);
                int memberIndex = value.variant.members.indexOf(key);
                if (memberIndex == -1) {
                    return Optional.absent();
                }
                return Optional.of(value.values.get(memberIndex));
            }
        }).set(new MetaObject.SlotDir(){

            public List<String> dir(TypedValue self, Frame<TypedValue> frame) {
                AltValue value = self.as(AltValue.class);
                return value.variant.members;
            }
        }).build();
    }

    public void registerSymbol(Environment<TypedValue> env) {
        env.setGlobalSymbol("alt", (TypedValue)((Object)new AltSymbol()));
    }

    private class AltSymbol
    implements ICallable<TypedValue> {
        private AltSymbol() {
        }

        @Override
        public void call(Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            TypedCalcUtils.expectExactArgCount(argumentsCount, 2);
            Frame<TypedValue> subframe = FrameFactory.newLocalFrameWithSubstack(frame, 2);
            Stack<TypedValue> substack = subframe.stack();
            Code code = substack.pop().as(Code.class, "second (code) 'alt' parameter");
            Cons vars = substack.pop().as(Cons.class, "first (definitions list) 'alt' parameter");
            try {
                this.prepareFrame(subframe.symbols(), vars);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to extract alt types description from: " + vars, e);
            }
            code.execute(subframe);
            TypedCalcUtils.expectExactReturnCount(returnsCount, substack.size());
        }

        private void prepareFrame(final SymbolMap<TypedValue> symbols, Cons vars) {
            vars.visit(new Cons.ListVisitor(AltExpressionFactory.this.nullValue){

                @Override
                public void value(TypedValue value, boolean isLast) {
                    AltSymbol.this.visitTypeDefinition(symbols, value);
                }
            });
        }

        private void visitTypeDefinition(SymbolMap<TypedValue> symbols, TypedValue typeDefinition) {
            Cons nameAndCtors = typeDefinition.as(Cons.class);
            Symbol name = nameAndCtors.car.as(Symbol.class);
            Cons ctors = nameAndCtors.cdr.as(Cons.class);
            final AltType newType = new AltType(name.value);
            symbols.put(name.value, newType.selfValue);
            ctors.visit(new Cons.ListVisitor(AltExpressionFactory.this.nullValue){

                @Override
                public void value(TypedValue value, boolean isLast) {
                    AltSymbol.this.visitConstructor(newType.members, newType, value);
                }
            });
            for (Map.Entry e : newType.members.entrySet()) {
                symbols.put((String)e.getKey(), (TypedValue)e.getValue());
            }
            newType.members.put("name", AltExpressionFactory.this.domain.create(String.class, newType.id));
        }

        private void visitConstructor(Map<String, TypedValue> variants, AltType type, TypedValue ctorDefinition) {
            Cons nameAndMembers = ctorDefinition.as(Cons.class);
            Symbol name = nameAndMembers.car.as(Symbol.class);
            final ArrayList memberNames = Lists.newArrayList();
            TypedValue membersList = nameAndMembers.cdr;
            if (membersList.is(Cons.class)) {
                Cons members = membersList.as(Cons.class);
                members.visit(new Cons.ListVisitor(AltExpressionFactory.this.nullValue){

                    @Override
                    public void value(TypedValue value, boolean isLast) {
                        memberNames.add(value.as(Symbol.class).value);
                    }
                });
            } else {
                Preconditions.checkState((membersList == AltExpressionFactory.this.nullValue ? 1 : 0) != 0, (String)"Expected list or null (empty list), got %s", (Object)membersList);
            }
            variants.put(name.value, AltExpressionFactory.this.domain.create(AltTypeVariant.class, new AltTypeVariant(name.value, type, memberNames)));
        }
    }

    private static class AltValue {
        private final AltTypeVariant variant;
        private final List<TypedValue> values;

        public AltValue(AltTypeVariant variant, List<TypedValue> values) {
            this.variant = variant;
            this.values = values;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
            result = 31 * result + (this.variant == null ? 0 : this.variant.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AltValue) {
                AltValue other = (AltValue)obj;
                return other.variant == this.variant && other.values.equals(this.values);
            }
            return false;
        }
    }

    private class AltTypeVariant
    extends TypeUserdata {
        private final String id;
        private final AltType type;
        private final List<String> members;
        private final TypedValue membersList;

        public AltTypeVariant(String name, AltType type, List<String> members) {
            super("alt_variant_" + type.id + "_" + name, AltValue.class);
            this.id = name;
            this.type = type;
            this.members = members;
            ImmutableList convertedMembers = ImmutableList.copyOf((Iterable)Iterables.transform(members, AltExpressionFactory.this.domain.createWrappingTransformer(String.class)));
            this.membersList = Cons.createList((List<TypedValue>)convertedMembers, AltExpressionFactory.this.nullValue);
        }
    }

    private class AltType
    extends TypeUserdata {
        private final String id;
        private final TypedValue selfValue;
        private Map<String, TypedValue> members;

        public AltType(String id) {
            super("alt_type_" + id, AltValue.class);
            this.members = Maps.newHashMap();
            this.id = id;
            this.selfValue = AltExpressionFactory.this.domain.create(AltType.class, this);
        }

        public Optional<TypedValue> attr(String key) {
            return Optional.fromNullable((Object)this.members.get(key));
        }

        @Override
        public Iterable<String> dir() {
            return this.members.keySet();
        }
    }

    private class AltNode
    extends ScopeModifierNode {
        public AltNode(List<IExprNode<TypedValue>> children) {
            super(AltExpressionFactory.this.domain, "alt", AltExpressionFactory.this.colonOperator, AltExpressionFactory.this.assignOperator, children);
        }

        @Override
        protected void flattenNameAndValue(List<IExecutable<TypedValue>> output, IExprNode<TypedValue> nameNode, IExprNode<TypedValue> ctorsNode) {
            output.add(Value.create(TypedCalcUtils.extractNameFromNode(AltExpressionFactory.this.domain, nameNode)));
            ArrayList ctors = Lists.newArrayList();
            this.flattenConstructorDefinitionList(ctors, ctorsNode);
            for (AltConstructorCompiler ctor : ctors) {
                ctor.flatten(output);
            }
            output.add(new SymbolCall("list", ctors.size(), 1));
        }

        private void flattenConstructorDefinitionList(List<AltConstructorCompiler> output, IExprNode<TypedValue> ctorsNode) {
            if (ctorsNode instanceof BinaryOpNode) {
                BinaryOpNode opNode = (BinaryOpNode)ctorsNode;
                Preconditions.checkState((opNode.operator == AltExpressionFactory.this.splitOperator ? 1 : 0) != 0, (String)"Malformed constructor list, expected '\\', got %s", opNode.operator);
                this.flattenConstructorDefinition(output, opNode.left);
                this.flattenConstructorDefinitionList(output, opNode.right);
            } else {
                this.flattenConstructorDefinition(output, ctorsNode);
            }
        }

        private void flattenConstructorDefinition(List<AltConstructorCompiler> output, IExprNode<TypedValue> ctorNode) {
            if (ctorNode instanceof SymbolGetNode) {
                SymbolGetNode getNode = (SymbolGetNode)ctorNode;
                output.add(new AltConstructorCompiler(getNode.symbol()));
            } else if (ctorNode instanceof SymbolCallNode) {
                SymbolCallNode callNode = (SymbolCallNode)ctorNode;
                AltConstructorCompiler result = new AltConstructorCompiler(callNode.symbol());
                for (IExprNode ctorArg : callNode.getChildren()) {
                    Preconditions.checkState((boolean)(ctorArg instanceof SymbolGetNode), (String)"Expected bare symbol, got %s", ctorArg);
                    result.addMember(((SymbolGetNode)ctorArg).symbol());
                }
                output.add(result);
            } else {
                throw new IllegalStateException("Expected alt type constructor, got " + ctorNode);
            }
        }
    }

    private class AltConstructorCompiler {
        private final List<String> parts;

        public AltConstructorCompiler(String name) {
            this.parts = Lists.newArrayList((Object[])new String[]{name});
        }

        public void addMember(String name) {
            this.parts.add(name);
        }

        public void flatten(List<IExecutable<TypedValue>> output) {
            ArrayList result = Lists.newArrayList();
            for (String s : this.parts) {
                result.add(AltExpressionFactory.this.domain.create(Symbol.class, Symbol.get(s)));
            }
            output.add(Value.create(Cons.createList(result, AltExpressionFactory.this.nullValue)));
        }
    }
}

