/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.blocks.coalgenerator;

import com.theundertaker11.geneticsreborn.GeneticsReborn;
import com.theundertaker11.geneticsreborn.util.CustomEnergyStorage;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBoat;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class GRTileEntityCoalGenerator
extends TileEntity
implements ITickable {
    public CustomEnergyStorage storage = new CustomEnergyStorage(100000);
    public int generation = GeneticsReborn.CoalGeneratorBaseRF;
    public boolean isGenerating = false;
    public int currentItemBurnTime = 0;
    public int burnTime = 0;
    public boolean hasOverclocker = false;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            GRTileEntityCoalGenerator.this.func_70296_d();
        }
    };

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isGenerating = nbt.func_74767_n("isGenerating");
        this.currentItemBurnTime = nbt.func_74762_e("currentItemBurnTime");
        this.burnTime = nbt.func_74762_e("burnTime");
        this.hasOverclocker = nbt.func_74767_n("hasOverclocker");
        this.generation = nbt.func_74762_e("generation");
        if (nbt.func_74764_b("items")) {
            this.inventory.deserializeNBT((NBTTagCompound)nbt.func_74781_a("items"));
        }
        this.storage.readFromNBT(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("items", (NBTBase)this.inventory.serializeNBT());
        nbt.func_74757_a("isGenerating", this.isGenerating);
        nbt.func_74768_a("currentItemBurnTime", this.currentItemBurnTime);
        nbt.func_74768_a("burnTime", this.burnTime);
        nbt.func_74757_a("hasOverclocker", this.hasOverclocker);
        nbt.func_74768_a("generation", this.generation);
        super.func_189515_b(nbt);
        return this.storage.writeToNBT(nbt);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
        if (this.storage.getMaxEnergyStored() - this.storage.getEnergyStored() >= this.generation) {
            if (!this.isGenerating) {
                if (!this.inventory.getStackInSlot(0).func_190926_b()) {
                    this.currentItemBurnTime = GRTileEntityCoalGenerator.getItemBurnTime(this.inventory.getStackInSlot(0));
                    if (this.currentItemBurnTime > 0) {
                        if (this.inventory.getStackInSlot(0).func_190916_E() > 1) {
                            this.inventory.getStackInSlot(0).func_190918_g(1);
                        } else {
                            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                        }
                        this.isGenerating = true;
                        this.func_70296_d();
                    } else {
                        this.isGenerating = false;
                        this.func_70296_d();
                    }
                }
            } else if (this.burnTime < this.currentItemBurnTime) {
                ++this.burnTime;
                this.storage.receiveEnergy(this.generation, false);
                this.func_70296_d();
            } else {
                this.burnTime = 0;
                this.isGenerating = false;
                this.func_70296_d();
            }
        }
        this.handleSendingEnergy();
    }

    public void addOverclocker() {
        if (!this.hasOverclocker) {
            this.hasOverclocker = true;
            this.generation *= 2;
            this.func_70296_d();
        }
    }

    public void removeOverclocker() {
        if (this.hasOverclocker) {
            this.hasOverclocker = false;
            this.generation /= 2;
            this.func_70296_d();
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int burnTime = ForgeEventFactory.getItemBurnTime((ItemStack)stack);
        if (burnTime >= 0) {
            return burnTime;
        }
        Item item = stack.func_77973_b();
        if (item == Item.func_150898_a((Block)Blocks.field_150376_bx)) {
            return 75;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150325_L)) {
            return 50;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150404_cg)) {
            return 30;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150468_ap)) {
            return 120;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150471_bO)) {
            return 50;
        }
        if (Block.func_149634_a((Item)item).func_176223_P().func_185904_a() == Material.field_151575_d) {
            return 120;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150402_ci)) {
            return 6000;
        }
        if (item instanceof ItemTool && "WOOD".equals(((ItemTool)item).func_77861_e())) {
            return 100;
        }
        if (item instanceof ItemSword && "WOOD".equals(((ItemSword)item).func_150932_j())) {
            return 100;
        }
        if (item instanceof ItemHoe && "WOOD".equals(((ItemHoe)item).func_77842_f())) {
            return 100;
        }
        if (item == Items.field_151055_y) {
            return 40;
        }
        if (item != Items.field_151031_f && item != Items.field_151112_aM) {
            if (item == Items.field_151155_ap) {
                return 100;
            }
            if (item == Items.field_151044_h) {
                return 1000;
            }
            if (item == Items.field_151129_at) {
                return 10000;
            }
            if (item != Item.func_150898_a((Block)Blocks.field_150345_g) && item != Items.field_151054_z) {
                if (item == Items.field_151072_bj) {
                    return 1200;
                }
                if (item instanceof ItemDoor && item != Items.field_151139_aw) {
                    return 200;
                }
                return item instanceof ItemBoat ? 200 : 0;
            }
            return 50;
        }
        return 150;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public double percentage() {
        return (double)this.burnTime / (double)this.currentItemBurnTime * 100.0;
    }

    public static boolean isEnergyTE(TileEntity te) {
        return te != null && te.hasCapability(CapabilityEnergy.ENERGY, null);
    }

    private void handleSendingEnergy() {
        int energyStored = this.storage.getEnergyStored();
        for (EnumFacing facing : EnumFacing.values()) {
            int rfToGive;
            EnumFacing opposite;
            int received;
            BlockPos pos = this.func_174877_v().func_177972_a(facing);
            TileEntity te = this.field_145850_b.func_175625_s(pos);
            if (GRTileEntityCoalGenerator.isEnergyTE(te) && (energyStored -= this.storage.extractEnergy(received = GRTileEntityCoalGenerator.receiveEnergy(te, opposite = facing.func_176734_d(), rfToGive = 2000 <= energyStored ? 2000 : energyStored), false)) <= 0) break;
        }
    }

    public static int receiveEnergy(TileEntity tileEntity, EnumFacing from, int maxReceive) {
        IEnergyStorage capability;
        if (tileEntity != null && tileEntity.hasCapability(CapabilityEnergy.ENERGY, from) && (capability = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, from)).canReceive()) {
            return capability.receiveEnergy(maxReceive, false);
        }
        return 0;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        ItemStackHandler handler;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (handler = this.inventory) != null) {
            return (T)handler;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.storage);
        }
        return (T)super.getCapability(capability, facing);
    }
}

