/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.api.capability.genes;

import com.theundertaker11.geneticsreborn.GeneticsReborn;
import com.theundertaker11.geneticsreborn.JsonHandler;
import com.theundertaker11.geneticsreborn.api.capability.genes.EnumGenes;
import com.theundertaker11.geneticsreborn.util.MobToGeneObject;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;

public class MobToGeneRegistry {
    private static HashSet<MobToGeneObject> list = new HashSet();

    public static void init() {
        if (GeneticsReborn.registerModGenes) {
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityVillager", new EnumGenes[]{EnumGenes.MOB_SIGHT, EnumGenes.EMERALD_HEART, EnumGenes.REGENERATION}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntitySheep", new EnumGenes[]{EnumGenes.EAT_GRASS, EnumGenes.WOOLY}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityCow", new EnumGenes[]{EnumGenes.EAT_GRASS, EnumGenes.MILKY}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityPig", new EnumGenes[]{EnumGenes.MEATY}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityHorse", new EnumGenes[]{EnumGenes.JUMP_BOOST, EnumGenes.STEP_ASSIST, EnumGenes.SPEED}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityChicken", new EnumGenes[]{EnumGenes.NO_FALL_DAMAGE, EnumGenes.LAY_EGG}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityBat", new EnumGenes[]{EnumGenes.MOB_SIGHT, EnumGenes.NIGHT_VISION}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityParrot", new EnumGenes[]{EnumGenes.NO_FALL_DAMAGE}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityOcelot", new EnumGenes[]{EnumGenes.SPEED, EnumGenes.SCARE_CREEPERS}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityPolarBear", new EnumGenes[]{EnumGenes.STRENGTH, EnumGenes.CLAWS, EnumGenes.STEP_ASSIST}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityLlama", new EnumGenes[]{EnumGenes.STRENGTH, EnumGenes.STEP_ASSIST}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityWolf", new EnumGenes[]{EnumGenes.SCARE_SKELETONS, EnumGenes.NIGHT_VISION, EnumGenes.NO_HUNGER}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityRabbit", new EnumGenes[]{EnumGenes.JUMP_BOOST, EnumGenes.SPEED}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntitySquid", EnumGenes.WATER_BREATHING));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityIronGolem", new EnumGenes[]{EnumGenes.MORE_HEARTS, EnumGenes.REGENERATION}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityZombie", EnumGenes.RESISTANCE));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityCreeper", new EnumGenes[]{EnumGenes.EXPLOSIVE_EXIT}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntitySpider", new EnumGenes[]{EnumGenes.NIGHT_VISION, EnumGenes.CLIMB_WALLS}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityCaveSpider", new EnumGenes[]{EnumGenes.NIGHT_VISION, EnumGenes.CLIMB_WALLS, EnumGenes.POISON_PROOF}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntitySlime", new EnumGenes[]{EnumGenes.NO_FALL_DAMAGE, EnumGenes.SLIMY}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityGuardian", new EnumGenes[]{EnumGenes.MOB_SIGHT, EnumGenes.WATER_BREATHING}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntitySkeleton", EnumGenes.INFINITY));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntitySilverfish", new EnumGenes[]{EnumGenes.HASTE, EnumGenes.EFFICIENCY}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityEndermite", new EnumGenes[]{EnumGenes.SAVE_INVENTORY, EnumGenes.ITEM_MAGNET, EnumGenes.XP_MAGNET}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityEnderman", new EnumGenes[]{EnumGenes.TELEPORTER, EnumGenes.MORE_HEARTS}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityShulker", new EnumGenes[]{EnumGenes.RESISTANCE, EnumGenes.REGENERATION}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("Wither Skeleton", new EnumGenes[]{EnumGenes.WITHER_HIT, EnumGenes.INFINITY}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityBlaze", new EnumGenes[]{EnumGenes.SHOOT_FIREBALLS, EnumGenes.FIRE_PROOF, EnumGenes.BIOLUMIN}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityGhast", new EnumGenes[]{EnumGenes.MOB_SIGHT, EnumGenes.SHOOT_FIREBALLS}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityPigZombie", new EnumGenes[]{EnumGenes.FIRE_PROOF, EnumGenes.MEATY}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityMagmaCube", new EnumGenes[]{EnumGenes.FIRE_PROOF, EnumGenes.BIOLUMIN}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("EntityWither", new EnumGenes[]{EnumGenes.WITHER_PROOF}));
            MobToGeneRegistry.registerMob(new MobToGeneObject("Ender Dragon", new EnumGenes[]{EnumGenes.DRAGONS_BREATH, EnumGenes.ENDER_DRAGON_HEALTH, EnumGenes.FLY}));
        }
        if (GeneticsReborn.registerModGenes) {
            try {
                if (Loader.isModLoaded((String)"arsmagica2")) {
                    MobToGeneRegistry.registerArsMagica();
                }
                if (Loader.isModLoaded((String)"grimoireofgaia")) {
                    MobToGeneRegistry.registerGrimoireOfGaia();
                }
                if (Loader.isModLoaded((String)"mocreatures")) {
                    MobToGeneRegistry.registerMoCreatures();
                }
                if (Loader.isModLoaded((String)"netherex")) {
                    MobToGeneRegistry.registerNEXMobs();
                }
                if (Loader.isModLoaded((String)"botania")) {
                    MobToGeneRegistry.registerBotaniaMobs();
                }
                if (Loader.isModLoaded((String)"cyberware")) {
                    MobToGeneRegistry.registerCyberMobs();
                }
            }
            catch (NoSuchMethodError e) {
                e.printStackTrace();
            }
        }
        JsonHandler.registerMobsFromJson();
    }

    public static void registerMob(MobToGeneObject obj) {
        list.add(obj);
    }

    public static String getGene(String entityCodeName) {
        int numb = ThreadLocalRandom.current().nextInt(1, 101);
        if (numb > 40) {
            return "GeneticsRebornBasicGene";
        }
        MobToGeneObject object = null;
        for (MobToGeneObject obj : list) {
            if (!obj.MobCodeName.equals(entityCodeName)) continue;
            object = obj;
            break;
        }
        if (object == null || object.getValidGenesNum() == 0) {
            return "GeneticsRebornBasicGene";
        }
        EnumGenes gene = object.getRandomGene();
        if (!gene.isActive()) {
            return "GeneticsRebornBasicGene";
        }
        return gene.toGeneName();
    }

    public static String getGene(ItemStack stack, String entityCodeName) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b("forceGene")) {
            return MobToGeneRegistry.getGene(entityCodeName);
        }
        if (tag.func_74767_n("mutation")) {
            EnumGenes gene;
            int chance = tag.func_74762_e("chance");
            if (tag.func_74764_b("overclocked")) {
                chance -= tag.func_74762_e("overclocked") * 13;
            }
            if (!tag.func_74767_n("lowTemp")) {
                chance = 3;
            }
            if ((gene = EnumGenes.fromGeneName(tag.func_74779_i("forceGene"))) == null) {
                GeneticsReborn.log.error("Invalid forced-gene: " + tag.func_74779_i("forceGene"));
                return "GeneticsRebornMutatedGene";
            }
            if (ThreadLocalRandom.current().nextInt(1, 101) <= chance) {
                return gene.getMutation().toGeneName();
            }
            if (gene != gene.getMutation()) {
                return gene.toGeneName();
            }
            return "GeneticsRebornMutatedGene";
        }
        if (ThreadLocalRandom.current().nextInt(1, 101) < tag.func_74762_e("chance")) {
            return EnumGenes.fromGeneName(tag.func_74779_i("forceGene")).toGeneName();
        }
        return "GeneticsRebornBasicGene";
    }

    public static void registerArsMagica() {
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityDryad", EnumGenes.PHOTOSYNTHESIS));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityNatureGuardian", EnumGenes.PHOTOSYNTHESIS));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityWaterGuardian", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityAirGuardian", EnumGenes.NO_FALL_DAMAGE));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityFireGuardian", new EnumGenes[]{EnumGenes.FIRE_PROOF, EnumGenes.BIOLUMIN}));
    }

    public static void registerGrimoireOfGaia() {
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityGaiaDryad", EnumGenes.PHOTOSYNTHESIS));
    }

    public static void registerCyberMobs() {
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityCyberZombie", EnumGenes.CYBERNETIC));
    }

    public static void registerBotaniaMobs() {
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityPinkWither", new EnumGenes[]{EnumGenes.WITHER_HIT, EnumGenes.WITHER_PROOF, EnumGenes.FLY}));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityPixie", new EnumGenes[]{EnumGenes.PHOTOSYNTHESIS, EnumGenes.NO_FALL_DAMAGE}));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityDoppleganger", new EnumGenes[]{EnumGenes.INVISIBLE, EnumGenes.LUCK}));
    }

    public static void registerNEXMobs() {
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntitySpinout", new EnumGenes[]{EnumGenes.FIRE_PROOF, EnumGenes.THORNS}));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityWight", new EnumGenes[]{EnumGenes.FIRE_PROOF, EnumGenes.NO_FALL_DAMAGE, EnumGenes.INVISIBLE}));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityCoolmarSpider", new EnumGenes[]{EnumGenes.NIGHT_VISION, EnumGenes.POISON_PROOF}));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityBrute", new EnumGenes[]{EnumGenes.STRENGTH, EnumGenes.MORE_HEARTS}));
    }

    public static void registerMoCreatures() {
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityFly", EnumGenes.FLY));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityAnchovy", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityAngelFish", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityAngler", new EnumGenes[]{EnumGenes.WATER_BREATHING, EnumGenes.BIOLUMIN}));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityBass", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityClownFish", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityCod", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityFishy", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityGoldFish", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityHippoTang", EnumGenes.STRENGTH));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityMantaRay", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityMediumFish", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityPiranha", new EnumGenes[]{EnumGenes.WATER_BREATHING, EnumGenes.CLAWS}));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityRay", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntitySalmon", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityShark", new EnumGenes[]{EnumGenes.WATER_BREATHING, EnumGenes.STRENGTH, EnumGenes.CLAWS}));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntitySmallFish", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityStringRay", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityFireOgre", new EnumGenes[]{EnumGenes.FIRE_PROOF, EnumGenes.BIOLUMIN}));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityOgre", EnumGenes.STRENGTH));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityWerewolf", new EnumGenes[]{EnumGenes.STRENGTH, EnumGenes.CLAWS, EnumGenes.EMERALD_HEART}));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityBear", new EnumGenes[]{EnumGenes.STRENGTH, EnumGenes.CLAWS}));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityBlackBear", new EnumGenes[]{EnumGenes.STRENGTH, EnumGenes.CLAWS}));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityBigCat", new EnumGenes[]{EnumGenes.SCARE_CREEPERS, EnumGenes.STEP_ASSIST}));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityBunny", new EnumGenes[]{EnumGenes.JUMP_BOOST, EnumGenes.SPEED}));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityKitty", EnumGenes.SCARE_CREEPERS));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityLion", EnumGenes.STRENGTH));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityScorpion", EnumGenes.POISON_PROOF));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityTurtle", EnumGenes.RESISTANCE));
    }
}

