/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.tools;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.client.particle.Particles;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;

public class Hatchet
extends AoeToolCore {
    public static final ImmutableSet<Material> effective_materials = ImmutableSet.of((Object)Material.field_151575_d, (Object)Material.field_151582_l, (Object)Material.field_151585_k, (Object)Material.field_151572_C, (Object)Material.field_151570_A);

    public Hatchet() {
        this(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.axeHead), PartMaterialType.extra(TinkerTools.binding));
    }

    protected Hatchet(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.addCategory(Category.HARVEST);
        this.addCategory(Category.WEAPON);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    public boolean isEffective(IBlockState state) {
        return effective_materials.contains((Object)state.func_185904_a()) || ItemAxe.field_150917_c.contains(state.func_177230_c());
    }

    @Override
    public float damagePotential() {
        return 1.1f;
    }

    @Override
    public double attackSpeed() {
        return 1.1f;
    }

    @Override
    public float knockback() {
        return 1.3f;
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (state.func_177230_c().func_149688_o(state) == Material.field_151584_j) {
            return ToolHelper.calcDigSpeed(stack, state);
        }
        return super.func_150893_a(stack, state);
    }

    @Override
    public void afterBlockBreak(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase player, int damage, boolean wasEffective) {
        if (state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos)) {
            damage = 0;
        }
        super.afterBlockBreak(stack, world, state, pos, player, damage, wasEffective);
    }

    @Override
    public boolean dealDamage(ItemStack stack, EntityLivingBase player, Entity entity, float damage) {
        boolean hit = super.dealDamage(stack, player, entity, damage);
        if (hit && this.readyForSpecialAttack(player)) {
            TinkerTools.proxy.spawnAttackParticle(Particles.HATCHET_ATTACK, (Entity)player, 0.8);
        }
        return hit;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, EntityLivingBase entity, EntityLivingBase attacker) {
        return true;
    }

    @Override
    protected ToolNBT buildTagData(List<slimeknights.tconstruct.library.materials.Material> materials) {
        ToolNBT data = this.buildDefaultTag(materials);
        data.attack += 0.5f;
        return data;
    }
}

