/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity.guide;

import com.google.common.base.Supplier;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import openblocks.client.renderer.tileentity.guide.IGuideRenderer;
import openblocks.common.tileentity.TileEntityGuide;
import openblocks.shapes.CoordShape;
import openmods.utils.OptionalInt;
import openmods.utils.TextureUtils;
import org.lwjgl.opengl.GL11;

public class GuideLegacyRenderer
implements IGuideRenderer {
    private OptionalInt markerDisplayList = OptionalInt.absent();
    private final FloatBuffer brightnessBuffer = GLAllocation.func_74529_h((int)4);

    @Override
    public void onModelBake(Supplier<BufferBuilder> model) {
        if (this.markerDisplayList.isPresent()) {
            GL11.glDeleteLists((int)this.markerDisplayList.get(), (int)1);
        }
        BufferBuilder vb = (BufferBuilder)model.get();
        int newList = GL11.glGenLists((int)1);
        GL11.glNewList((int)newList, (int)4864);
        new WorldVertexBufferUploader().func_181679_a(vb);
        GL11.glEndList();
        this.markerDisplayList = OptionalInt.of((int)newList);
    }

    @Override
    public void renderShape(TileEntityGuide guide) {
        float scaleDelta = guide.getTimeSinceChange();
        this.renderShape(guide.getShape(), guide.getColor(), scaleDelta);
        if ((double)scaleDelta < 1.0) {
            this.renderShape(guide.getPreviousShape(), guide.getColor(), 1.0f - scaleDelta);
        }
    }

    private static float byteToFloat(int value) {
        return (float)(value & 0xFF) / 255.0f;
    }

    private void renderShape(CoordShape shape, int color, float scale) {
        if (shape == null || !this.markerDisplayList.isPresent()) {
            return;
        }
        int displayList = this.markerDisplayList.get();
        TextureUtils.bindTextureToClient((ResourceLocation)TextureMap.field_110575_b);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179140_f();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179098_w();
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        this.brightnessBuffer.position(0);
        this.brightnessBuffer.put(GuideLegacyRenderer.byteToFloat(color >> 16));
        this.brightnessBuffer.put(GuideLegacyRenderer.byteToFloat(color >> 8));
        this.brightnessBuffer.put(GuideLegacyRenderer.byteToFloat(color >> 0));
        this.brightnessBuffer.put(1.0f);
        this.brightnessBuffer.flip();
        GlStateManager.func_187448_b((int)8960, (int)8705, (FloatBuffer)this.brightnessBuffer);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)5890);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)34166);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)5890);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        for (BlockPos coord : shape.getCoords()) {
            GuideLegacyRenderer.renderMarkerAt(displayList, coord.func_177958_n(), coord.func_177956_o(), coord.func_177952_p(), scale);
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187417_n();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
    }

    private static void renderMarkerAt(int markerDisplayList, double x, double y, double z, float scale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glCallList((int)markerDisplayList);
        GL11.glPopMatrix();
    }
}

