/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.densemetals;

import com.mcmoddev.densemetals.DenseMetalsConfig;
import com.mcmoddev.densemetals.blocks.BlockDenseOre;
import com.mcmoddev.densemetals.gen.DenseMetalGen;
import com.mcmoddev.densemetals.gen.WorldGenEntry;
import com.mcmoddev.densemetals.init.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="densemetals", name="Dense Metals", version="2.0.0", acceptedMinecraftVersions="[1.12,)", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", updateJSON="https://raw.githubusercontent.com/MinecraftModDevelopmentMods/DenseMetals/master/update.json")
public class DenseMetals {
    public static final String MODID = "densemetals";
    public static final String MODNAME = "Dense Metals";
    public static final String VERSION = "2.0.0";
    protected static final String UPDATEJSON = "https://raw.githubusercontent.com/MinecraftModDevelopmentMods/DenseMetals/master/update.json";
    public static final CreativeTabs TAB = new CreativeTabs("densemetals"){

        public ItemStack func_78016_d() {
            return new ItemStack((Block)ModBlocks.DENSE_ORES.get(0));
        }
    };
    public static final Logger LOGGER = LogManager.getLogger((String)"densemetals");
    public static Configuration config;

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        LOGGER.warn("Invalid fingerprint detected!");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModBlocks.DENSE_ORES.forEach(bl -> DenseMetals.sendVeinMinerIMC(bl));
        config = new Configuration(event.getSuggestedConfigurationFile());
        DenseMetalsConfig.readConfig();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModBlocks.DENSE_ORES.forEach(bl -> DenseMetals.sendVeinMinerIMC(bl));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModBlocks.DENSE_ORES.forEach(bl -> {
            String path;
            if (bl.resolve() && DenseMetalsConfig.doWorldGen && config.getBoolean("Generate", path = bl.getRegistryName().func_110623_a(), true, "If this ore will attempt to replace ores with itself.")) {
                int yMin = config.getInt("Min Y Level", path, bl.getYMin(), 0, 255, "The minimum Y level replacement will occur at.");
                int yMax = config.getInt("Max Y Level", path, bl.getYMax(), 0, 255, "The maximum Y level replacement will occur at.");
                int chance = config.getInt("Spawn Chances", path, bl.getChance(), 0, 255, "How many times this ore will attempt to spawn each chunk.  A value of 0 will not generate.");
                int dim = config.getInt("Dimension", path, bl.getDim(), Integer.MIN_VALUE, Integer.MAX_VALUE, "What dimension this replacement occurs in.");
                if (yMax >= yMin && chance > 0) {
                    DenseMetalGen.GENERATORS.add(new WorldGenEntry((BlockDenseOre)((Object)bl), yMin, yMax, chance, dim));
                }
            }
        });
        if (config.hasChanged()) {
            config.save();
        }
        GameRegistry.registerWorldGenerator((IWorldGenerator)new DenseMetalGen(), (int)0);
    }

    public static void sendVeinMinerIMC(Block block) {
        NBTTagCompound message = new NBTTagCompound();
        message.func_74778_a("whitelistType", "block");
        message.func_74778_a("toolType", "pickaxe");
        message.func_74778_a("blockName", block.getRegistryName().toString());
        FMLInterModComms.sendMessage((String)"veinminer", (String)"whitelist", (NBTTagCompound)message);
    }
}

