/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.util;

import com.feed_the_beast.ftblib.lib.util.StringUtils;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;

public class EnumDyeColorHelper {
    public static final EnumDyeColorHelper[] HELPERS = new EnumDyeColorHelper[EnumDyeColor.values().length];
    private final EnumDyeColor dye;
    private final String langKey;
    private final String oreName;

    private EnumDyeColorHelper(EnumDyeColor col) {
        this.dye = col;
        this.langKey = "item.fireworksCharge." + col.func_176762_d();
        this.oreName = StringUtils.firstUppercase(col.func_176762_d());
    }

    public static EnumDyeColorHelper get(EnumDyeColor dye) {
        return HELPERS[dye.ordinal()];
    }

    public ItemStack getDye(int s) {
        return new ItemStack(Items.field_151100_aR, s, this.dye.func_176767_b());
    }

    public String toString() {
        return this.dye.func_176610_l();
    }

    public int hashCode() {
        return this.dye.ordinal();
    }

    public EnumDyeColor getDye() {
        return this.dye;
    }

    public String getLangKey() {
        return this.langKey;
    }

    public String getOreName() {
        return this.oreName;
    }

    public String getDyeName() {
        return "dye" + this.getOreName();
    }

    public String getGlassName() {
        return "blockGlass" + this.getOreName();
    }

    public String getPaneName() {
        return "paneGlass" + this.getOreName();
    }

    static {
        for (EnumDyeColor c : EnumDyeColor.values()) {
            EnumDyeColorHelper.HELPERS[c.ordinal()] = new EnumDyeColorHelper(c);
        }
    }
}

