/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.trees.nether;

import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.world.worldgen.trees.BaseTreeGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class BloodwoodTreeGenerator
extends BaseTreeGenerator {
    public final IBlockState full;
    public final IBlockState trunk1;
    public final IBlockState trunk2;
    public final IBlockState trunk3;
    public final IBlockState trunk4;
    public final IBlockState leaves;

    public BloodwoodTreeGenerator(IBlockState full, IBlockState trunk1, IBlockState trunk2, IBlockState trunk3, IBlockState trunk4, IBlockState leaves) {
        this.full = full;
        this.trunk1 = trunk1;
        this.trunk2 = trunk2;
        this.trunk3 = trunk3;
        this.trunk4 = trunk4;
        this.leaves = leaves;
    }

    BlockPos findCeiling(World world, BlockPos pos) {
        int returnHeight = 0;
        int height = pos.func_177956_o();
        do {
            BlockPos position;
            Block block;
            if ((block = world.func_180495_p(position = new BlockPos(pos.func_177958_n(), height, pos.func_177952_p())).func_177230_c()) != Blocks.field_150424_aL && block != Blocks.field_150425_aM && block != NaturaNether.netherTaintedSoil || world.func_180495_p(position.func_177977_b()).func_185913_b()) continue;
            returnHeight = height - 1;
            break;
        } while (++height <= 120);
        return new BlockPos(pos.func_177958_n(), returnHeight, pos.func_177952_p());
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
    }

    @Override
    public void generateTree(Random random, World world, BlockPos pos) {
        int treeHeight = random.nextInt(8) + 8;
        if ((pos = this.findCeiling(world, pos)).func_177956_o() < 0) {
            return;
        }
        for (int heightIter = 0; heightIter < treeHeight; ++heightIter) {
            Block localBlock = world.func_180495_p(pos.func_177982_a(0, -heightIter, 0)).func_177230_c();
            if (localBlock != Blocks.field_150350_a && localBlock != NaturaNether.netherLeaves) continue;
            this.setBlockAndMetadata(world, pos.func_177982_a(0, -heightIter, 0), this.trunk1);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, -heightIter, 0), this.trunk2);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, -heightIter, 1), this.trunk3);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, -heightIter, 1), this.trunk4);
        }
        this.genBranch(world, random, pos, -treeHeight, 1);
        this.genBranch(world, random, pos.func_177982_a(1, 0, 0), -treeHeight, 2);
        this.genBranch(world, random, pos.func_177982_a(0, 0, 1), -treeHeight, 3);
        this.genBranch(world, random, pos.func_177982_a(1, 0, 1), -treeHeight, 4);
        this.genStraightBranch(world, random, pos, -treeHeight, 1);
        this.genStraightBranch(world, random, pos.func_177982_a(1, 0, 0), -treeHeight, 2);
        this.genStraightBranch(world, random, pos.func_177982_a(0, 0, 1), -treeHeight, 3);
        this.genStraightBranch(world, random, pos.func_177982_a(1, 0, 1), -treeHeight, 4);
    }

    private void genBranch(World world, Random random, BlockPos pos, int height, int direction) {
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o() + height;
        int posZ = pos.func_177952_p();
        int offsetX = 0;
        int offsetZ = 0;
        switch (direction) {
            case 1: {
                offsetX = 1;
                offsetZ = 1;
                break;
            }
            case 2: {
                offsetX = -1;
                offsetZ = 1;
                break;
            }
            case 3: {
                offsetX = 1;
                offsetZ = -1;
                break;
            }
            case 4: {
                offsetX = -1;
                offsetZ = -1;
            }
        }
        int heightShift = random.nextInt(6);
        for (int bIter = 4; bIter > 0; --bIter) {
            if (heightShift % 3 != 0) {
                posX += offsetX;
            }
            if (heightShift % 3 != 1) {
                posZ += offsetZ;
            }
            int branch = heightShift % 3 - 1;
            BlockPos blockpos = new BlockPos(posX, posY += branch, posZ);
            this.generateNode(world, random, blockpos);
            heightShift = random.nextInt(6);
        }
    }

    private void genStraightBranch(World world, Random random, BlockPos pos, int height, int direction) {
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o() + height;
        int posZ = pos.func_177952_p();
        int xShift = 0;
        int zShift = 0;
        switch (direction) {
            case 1: {
                xShift = 1;
                zShift = 0;
                break;
            }
            case 2: {
                xShift = 0;
                zShift = 1;
                break;
            }
            case 3: {
                xShift = -1;
                zShift = 0;
                break;
            }
            case 4: {
                xShift = 0;
                zShift = -1;
            }
        }
        int heightShift = random.nextInt(6);
        for (int j2 = 4; j2 > 0; --j2) {
            if (xShift == 0) {
                posX = posX + random.nextInt(3) - 1;
                posZ += zShift;
            }
            if (zShift == 0) {
                posX += xShift;
                posZ = posZ + random.nextInt(3) - 1;
            }
            int branch = heightShift % 3 - 1;
            BlockPos blockpos = new BlockPos(posX, posY += branch, posZ);
            this.generateNode(world, random, blockpos);
            heightShift = random.nextInt(6);
        }
    }

    public boolean generateNode(World world, Random random, BlockPos pos) {
        Block block;
        IBlockState state;
        BlockPos newPos;
        int zIter;
        int xIter;
        this.setBlockAndMetadata(world, pos, this.full);
        for (xIter = pos.func_177958_n() - 1; xIter <= pos.func_177958_n() + 1; ++xIter) {
            for (zIter = pos.func_177952_p() - 1; zIter <= pos.func_177952_p() + 1; ++zIter) {
                newPos = new BlockPos(xIter, pos.func_177956_o(), zIter);
                state = world.func_180495_p(newPos);
                block = state.func_177230_c();
                if (block == NaturaNether.netherLeaves || state.func_185913_b()) continue;
                this.setBlockAndMetadata(world, newPos, this.leaves);
            }
        }
        for (xIter = pos.func_177958_n() - 1; xIter <= pos.func_177958_n() + 1; ++xIter) {
            for (zIter = pos.func_177952_p() - 2; zIter <= pos.func_177952_p() + 2; ++zIter) {
                newPos = new BlockPos(xIter, pos.func_177956_o(), zIter);
                state = world.func_180495_p(newPos);
                block = state.func_177230_c();
                if (block == NaturaNether.netherLeaves || state.func_185913_b()) continue;
                this.setBlockAndMetadata(world, newPos, this.leaves);
            }
        }
        for (xIter = pos.func_177958_n() - 2; xIter <= pos.func_177958_n() + 2; ++xIter) {
            for (zIter = pos.func_177952_p() - 1; zIter <= pos.func_177952_p() + 1; ++zIter) {
                newPos = new BlockPos(xIter, pos.func_177956_o() + 1, zIter);
                state = world.func_180495_p(newPos);
                block = state.func_177230_c();
                if (block == NaturaNether.netherLeaves || state.func_185913_b()) continue;
                this.setBlockAndMetadata(world, newPos, this.leaves);
            }
        }
        return true;
    }

    protected void setBlockAndMetadata(World world, BlockPos pos, IBlockState stateNew) {
        world.func_180501_a(pos, stateNew, 2);
    }
}

