/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.overworld.item;

import com.progwml6.natura.library.NaturaRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.util.LocUtils;

public class ItemSaguaroFruit
extends ItemSeedFood {
    public final Block crop;

    public ItemSaguaroFruit(int healAmount, float saturation, Block crop) {
        super(healAmount, saturation, crop, Blocks.field_150458_ak);
        this.crop = crop;
        this.func_77637_a((CreativeTabs)NaturaRegistry.tabGeneral);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (facing != EnumFacing.UP) {
            return EnumActionResult.FAIL;
        }
        ItemStack itemstack = player.func_184586_b(hand);
        if (player.func_175151_a(pos, facing, itemstack) && player.func_175151_a(pos.func_177984_a(), facing, itemstack)) {
            IBlockState state = worldIn.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block != null && block.canSustainPlant(state, (IBlockAccess)worldIn, pos, EnumFacing.UP, (IPlantable)this.crop) && worldIn.func_175623_d(pos.func_177984_a())) {
                worldIn.func_175656_a(pos.func_177984_a(), this.crop.func_176223_P());
                itemstack.func_190918_g(1);
                return EnumActionResult.SUCCESS;
            }
        } else {
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ItemSaguaroFruit.addOptionalTooltip(stack, tooltip);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static void addOptionalTooltip(ItemStack stack, List<String> tooltip) {
        if (I18n.func_94522_b((String)(stack.func_77977_a() + ".tooltip"))) {
            tooltip.addAll(LocUtils.getTooltips((String)(TextFormatting.GRAY.toString() + LocUtils.translateRecursive((String)(stack.func_77977_a() + ".tooltip"), (Object[])new Object[0]))));
        } else if (I18n.func_94522_b((String)(stack.func_77977_a() + ".tooltip"))) {
            tooltip.addAll(LocUtils.getTooltips((String)(TextFormatting.GRAY.toString() + LocUtils.translateRecursive((String)(stack.func_77977_a() + ".tooltip"), (Object[])new Object[0]))));
        }
    }
}

