/*
 * Decompiled with CFR 0.152.
 */
package zero.temp;

import it.zerono.mods.zerocore.util.CodeHelper;
import it.zerono.mods.zerocore.util.ItemHelper;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class RecipeHelper2 {
    public static final String EMPTY_ROW3 = "   ";

    public static void addSmelting(@Nonnull Block input, @Nonnull ItemStack output, float xp) {
        GameRegistry.addSmelting((Block)input, (ItemStack)output, (float)xp);
    }

    public static void addSmelting(@Nonnull Item input, @Nonnull ItemStack output, float xp) {
        GameRegistry.addSmelting((Item)input, (ItemStack)output, (float)xp);
    }

    public static void addSmelting(@Nonnull ItemStack input, @Nonnull ItemStack output, float xp) {
        GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)xp);
    }

    public static void addShaped(@Nonnull IForgeRegistry<IRecipe> registry, @Nonnull ItemStack result, Object ... recipe) {
        ShapedOreRecipe newRecipe;
        boolean useOreDict = false;
        for (int i = 3; i < recipe.length; ++i) {
            if (!(recipe[i] instanceof String)) continue;
            useOreDict = true;
        }
        ResourceLocation name = RecipeHelper2.getNameForRecipe(registry, result);
        if (useOreDict) {
            newRecipe = new ShapedOreRecipe(name, result, recipe);
        } else {
            CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])recipe);
            newRecipe = new ShapedRecipes(result.func_77973_b().getRegistryName().toString(), primer.width, primer.height, primer.input, result);
        }
        newRecipe.setRegistryName(name);
        registry.register((IForgeRegistryEntry)newRecipe);
    }

    public static void addShapeless(@Nonnull IForgeRegistry<IRecipe> registry, @Nonnull ItemStack result, Object ... recipe) {
        ShapelessOreRecipe newRecipe;
        boolean useOreDict = false;
        for (int i = 0; i < recipe.length; ++i) {
            if (!(recipe[i] instanceof String)) continue;
            useOreDict = true;
        }
        ResourceLocation name = RecipeHelper2.getNameForRecipe(registry, result);
        if (useOreDict) {
            newRecipe = new ShapelessOreRecipe(name, result, recipe);
        } else {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (Object object : recipe) {
                if (object instanceof ItemStack) {
                    list.add(ItemHelper.stackFrom((ItemStack)((ItemStack)object)));
                    continue;
                }
                if (object instanceof Item) {
                    list.add(new ItemStack((Item)object));
                    continue;
                }
                if (object instanceof Block) {
                    list.add(new ItemStack((Block)object));
                    continue;
                }
                throw new IllegalArgumentException("Invalid shapeless recipe: unknown ingredient type " + object.getClass().getName());
            }
            newRecipe = new ShapelessRecipes(name.func_110624_b(), result, RecipeHelper2.buildIngredientsList(recipe));
        }
        newRecipe.setRegistryName(name);
        registry.register((IForgeRegistryEntry)newRecipe);
    }

    private static ResourceLocation getNameForRecipe(@Nonnull IForgeRegistry<IRecipe> registry, ItemStack output) {
        ResourceLocation baseName;
        String callingModId = CodeHelper.getModIdFromActiveModContainer();
        ResourceLocation recipeName = baseName = new ResourceLocation(callingModId, output.func_77973_b().getRegistryName().func_110623_a());
        int index = 0;
        while (registry.containsKey(recipeName)) {
            recipeName = new ResourceLocation(callingModId, baseName.func_110623_a() + "_" + index++);
        }
        return recipeName;
    }

    private static NonNullList<Ingredient> buildIngredientsList(Object ... input) {
        NonNullList list = NonNullList.func_191196_a();
        for (Object obj : input) {
            if (obj instanceof Ingredient) {
                list.add((Object)((Ingredient)obj));
                continue;
            }
            Ingredient ingredient = CraftingHelper.getIngredient((Object)obj);
            list.add((Object)(null == ingredient ? Ingredient.field_193370_a : ingredient));
        }
        return list;
    }
}

