/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchStage;
import thelm.jaopca.api.EnumEntryType;
import thelm.jaopca.api.EnumOreType;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.ItemEntry;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.ModuleBase;
import thelm.jaopca.api.utils.Utils;

public class ModuleThaumcraft
extends ModuleBase {
    public static final String SPECIAL_MINING_MESSAGE = "%d,%d,%d,%d,%f";
    public static final ItemEntry NATIVE_CLUSTER_ENTRY = new ItemEntry(EnumEntryType.ITEM, "cluster", new ModelResourceLocation("jaopca:cluster#inventory"), (Collection<String>)ImmutableList.of((Object)"Iron", (Object)"Gold", (Object)"Copper", (Object)"Tin", (Object)"Silver", (Object)"Lead", (Object)"Cinnabar", (Object)"Quartz"));

    @Override
    public String getName() {
        return "thaumcraft";
    }

    @Override
    public EnumSet<EnumOreType> getOreTypes() {
        return Utils.enumSetOf((Enum[])EnumOreType.ORE);
    }

    @Override
    public List<String> getOreBlacklist() {
        return Lists.newArrayList((Object[])new String[]{"Diamond", "Redstone", "Lapis", "Emerald", "Gold", "Iron", "Cinnabar", "Copper", "Tin", "Silver", "Lead", "Quartz"});
    }

    public List<ItemEntry> getItemRequests() {
        return Lists.newArrayList((Object[])new ItemEntry[]{NATIVE_CLUSTER_ENTRY});
    }

    @Override
    public void init() {
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"cluster")) {
            Utils.addSmelting(Utils.getOreStack("cluster", entry, 1), Utils.getOreStack("ingot", entry, 2), 1.0f);
            if (Utils.doesOreNameExist("nugget" + entry.getOreName())) {
                ModuleThaumcraft.addSmeltingBonus(Utils.getOreStack("cluster", entry, 1), Utils.getOreStack("nugget", entry, 1));
            }
            ModuleThaumcraft.addSmeltingBonus(Utils.getOreStack("cluster", entry, 1), new ItemStack(ItemsTC.nuggets, 1, 10), 0.02f);
            for (ItemStack ore : Utils.getOres("ore" + entry.getOreName())) {
                ModuleThaumcraft.addSpecialMiningResult(ore, Utils.getOreStack("cluster", entry, 1), 1.0f);
            }
        }
        for (IOreEntry entry : JAOPCAApi.MODULE_TO_ORES_MAP.get((Object)this)) {
            if (Utils.doesOreNameExist("nugget" + entry.getOreName())) {
                ModuleThaumcraft.addSmeltingBonus("ore" + entry.getOreName(), Utils.getOreStack("nugget", entry, 1));
            }
            ModuleThaumcraft.addSmeltingBonus("ore" + entry.getOreName(), new ItemStack(ItemsTC.nuggets, 1, 10), (float)(entry.getRarity() * 0.01));
        }
    }

    @Override
    public void postInit() {
        ArrayList addedRecipes = Lists.newArrayList();
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"cluster")) {
            ResourceLocation rl = new ResourceLocation("jaopca:metal_purification_" + Utils.to_under_score(entry.getOreName()));
            ThaumcraftApi.addCrucibleRecipe((ResourceLocation)rl, (CrucibleRecipe)new CrucibleRecipe("METALPURIFICATION", Utils.getOreStack("cluster", entry, 1), (Object)("ore" + entry.getOreName()), new AspectList().merge(Aspect.METAL, 5).merge(Aspect.ORDER, 5)));
            addedRecipes.add(rl);
        }
        try {
            ResearchStage stage = ResearchCategories.getResearch((String)"METALPURIFICATION").getStages()[0];
            ArrayList recipes = Lists.newArrayList((Object[])stage.getRecipes());
            recipes.addAll(addedRecipes);
            stage.setRecipes(recipes.toArray(new ResourceLocation[recipes.size()]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addSmeltingBonus(Object in, ItemStack out) {
        ThaumcraftApi.addSmeltingBonus((Object)in, (ItemStack)out);
    }

    public static void addSmeltingBonus(Object in, ItemStack out, float chance) {
        ThaumcraftApi.addSmeltingBonus((Object)in, (ItemStack)out, (float)chance);
    }

    public static void addSpecialMiningResult(ItemStack in, ItemStack out, float chance) {
        FMLInterModComms.sendMessage((String)"thaumcraft", (String)"nativeCluster", (String)String.format(SPECIAL_MINING_MESSAGE, Item.func_150891_b((Item)in.func_77973_b()), in.func_77952_i(), Item.func_150891_b((Item)out.func_77973_b()), out.func_77952_i(), Float.valueOf(chance)));
    }
}

