/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.entity.ai;

import crazypants.enderio.zoo.entity.EntityUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class EntityAIFlyingLand
extends EntityAIBase {
    @Nonnull
    private EntityCreature entity;
    protected double speed;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int onGroundCount = 0;
    private int defSearchRange = 3;
    private int maxSearchRange = 16;
    private int searchRange = 4;
    private int searchAttempts = 10;

    public EntityAIFlyingLand(@Nonnull EntityCreature creature, double speedIn) {
        this.entity = creature;
        this.speed = speedIn;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        int distFromGround;
        if (this.entity.field_70122_E || !this.entity.func_70661_as().func_75500_f()) {
            return false;
        }
        BlockPos target = null;
        BlockPos ep = this.entity.func_180425_c();
        BlockPos blockLocationResult = EntityUtil.findClearLandingSurface((EntityLiving)this.entity, ep.func_177958_n(), ep.func_177952_p(), 1, ep.func_177956_o());
        if (blockLocationResult != null && (distFromGround = ep.func_177956_o() - blockLocationResult.func_177956_o()) < 2) {
            target = blockLocationResult;
        }
        if (target == null) {
            target = EntityUtil.findRandomLandingSurface(this.entity, this.searchRange, 1, ep.func_177956_o() + 1, this.searchAttempts);
        }
        if (target != null && (distFromGround = ep.func_177956_o() - target.func_177956_o()) > 12) {
            target = EntityUtil.findRandomClearArea(this.entity, this.searchRange, ep.func_177956_o() - 10, ep.func_177956_o() - 5, this.searchAttempts);
        }
        if (target == null) {
            this.searchRange = Math.min(this.searchRange + 1, this.maxSearchRange);
            return false;
        }
        this.searchRange = this.defSearchRange;
        this.targetX = (double)target.func_177958_n() + 0.5;
        this.targetY = target.func_177956_o();
        this.targetZ = (double)target.func_177952_p() + 0.5;
        return true;
    }

    public void func_75249_e() {
        this.onGroundCount = 0;
        if (!this.entity.func_70661_as().func_75492_a(this.targetX, this.targetY, this.targetZ, this.speed)) {
            // empty if block
        }
    }

    public boolean func_75253_b() {
        boolean isStillNavigating;
        if (this.entity.field_70122_E) {
            ++this.onGroundCount;
            if (this.onGroundCount >= 40) {
                this.entity.func_70661_as().func_75499_g();
                return false;
            }
            double fx = this.entity.field_70165_t - Math.floor(this.entity.field_70165_t);
            double fz = this.entity.field_70165_t - Math.floor(this.entity.field_70165_t);
            if (fx > 0.4 && fx < 0.6 && fz > 0.4 && fz < 0.6) {
                BlockPos bellow = this.entity.func_180425_c().func_177977_b();
                IBlockState bs = this.entity.func_130014_f_().func_180495_p(bellow);
                if (!bs.func_177230_c().isAir(bs, (IBlockAccess)this.entity.func_130014_f_(), bellow)) {
                    this.entity.func_70661_as().func_75499_g();
                    return false;
                }
            }
        }
        boolean bl = isStillNavigating = !this.entity.func_70661_as().func_75500_f();
        if (!isStillNavigating) {
            this.entity.field_70122_E = EntityUtil.isOnGround(this.entity);
            boolean bl2 = this.entity.field_70160_al = !this.entity.field_70122_E;
            if (!this.entity.field_70122_E) {
                this.entity.func_70107_b(this.entity.field_70165_t, this.entity.field_70163_u - 0.01, this.entity.field_70161_v);
            }
        }
        return isStillNavigating;
    }
}

