/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.entity;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.loot.EntityLootHelper;
import crazypants.enderio.zoo.config.ZooConfig;
import crazypants.enderio.zoo.entity.EntityFallenMount;
import crazypants.enderio.zoo.entity.EntityUtil;
import crazypants.enderio.zoo.entity.IEnderZooEntity;
import crazypants.enderio.zoo.entity.SpawnUtil;
import crazypants.enderio.zoo.entity.ai.EntityAIMountedArrowAttack;
import crazypants.enderio.zoo.entity.ai.EntityAIMountedAttackOnCollide;
import crazypants.enderio.zoo.entity.navigate.PathNavigateGroundMounted;
import crazypants.enderio.zoo.entity.render.RenderFallenKnight;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderiozoo")
public class EntityFallenKnight
extends EntitySkeleton
implements IEnderZooEntity.Aggressive {
    @Nonnull
    public static final String NAME = "fallenknight";
    public static final int EGG_FG_COL = 3562021;
    public static final int EGG_BG_COL = 0xA0A0A0;
    @Nonnull
    private final EntityAIMountedArrowAttack aiArrowAttack = new EntityAIMountedArrowAttack((IRangedAttackMob)this, ZooConfig.fallenKnightChargeSpeed, ZooConfig.fallenMountChargeSpeed, ZooConfig.fallenKnightRangedMinAttackPause, ZooConfig.fallenKnightRangedMaxAttackPause, ZooConfig.fallenKnightRangedMaxRange, ZooConfig.fallKnightMountedArchersMaintainDistance);
    @Nonnull
    private final EntityAIMountedAttackOnCollide aiAttackOnCollide = new EntityAIMountedAttackOnCollide((EntityCreature)this, EntityPlayer.class, ZooConfig.fallenKnightChargeSpeed, ZooConfig.fallenMountChargeSpeed, false);
    @Nonnull
    private final EntityAIBreakDoor breakDoorAI = new EntityAIBreakDoor((EntityLiving)this);
    private boolean canBreakDoors = false;
    private EntityLivingBase lastAttackTarget = null;
    private boolean knightFirstUpdate = true;
    private boolean isMounted = false;
    private boolean spawned = false;

    @SubscribeEvent
    public static void onEntityRegister(@Nonnull RegistryEvent.Register<EntityEntry> event) {
        IEnderZooEntity.register(event, NAME, EntityFallenKnight.class, 0xA0A0A0, 3562021, IEnderZooEntity.MobID.FKNIGHT);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPreInit(EnderIOLifecycleEvent.PreInit event) {
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("enderio", NAME));
        RenderingRegistry.registerEntityRenderingHandler(EntityFallenKnight.class, (IRenderFactory)RenderFallenKnight.FACTORY);
    }

    public EntityFallenKnight(World world) {
        super(world);
        this.setCombatTaskReal();
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, AbstractIllager.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(((Double)ZooConfig.fallenKnightFollowRange.get()).doubleValue());
        this.applyAttributes((EntityLivingBase)this, ZooConfig.fallenKnightHealth, ZooConfig.fallenKnightAttackDamage);
    }

    @Nonnull
    protected PathNavigate func_175447_b(@Nonnull World worldIn) {
        return new PathNavigateGroundMounted((EntityLiving)this, worldIn);
    }

    public void func_85036_m() {
    }

    public void setCombatTaskReal() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.getAiAttackOnCollide());
        this.field_70714_bg.func_85156_a((EntityAIBase)this.getAiArrowAttack());
        if (this.isRanged()) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.getAiArrowAttack());
        } else {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.getAiAttackOnCollide());
        }
    }

    public void func_184201_a(@Nonnull EntityEquipmentSlot slotIn, @Nonnull ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        this.setCombatTaskReal();
    }

    @Nonnull
    public EntityAIMountedArrowAttack getAiArrowAttack() {
        return this.aiArrowAttack;
    }

    @Nonnull
    public EntityAIMountedAttackOnCollide getAiAttackOnCollide() {
        return this.aiAttackOnCollide;
    }

    @Nonnull
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187899_gZ;
    }

    @Nonnull
    protected SoundEvent func_184601_bQ(@Nonnull DamageSource source) {
        return SoundEvents.field_187934_hh;
    }

    @Nonnull
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187930_hd;
    }

    public void func_70636_d() {
        EntityLiving entLiving;
        super.func_70636_d();
        if (this.knightFirstUpdate && !this.field_70170_p.field_72995_K) {
            this.spawnMount();
        }
        EntityLivingBase attackTarget = this.func_70638_az();
        if (this.isRidingMount() && (entLiving = (EntityLiving)this.func_184187_bx()) != null && (this.lastAttackTarget != attackTarget || this.knightFirstUpdate)) {
            EntityUtil.cancelCurrentTasks(entLiving);
            this.lastAttackTarget = attackTarget;
        }
        this.knightFirstUpdate = false;
        if (!this.isMounted == this.isRidingMount()) {
            this.getAiAttackOnCollide().func_75251_c();
            this.getAiArrowAttack().func_75251_c();
            this.func_70661_as().func_75499_g();
            this.isMounted = this.isRidingMount();
        }
        if (this.func_70027_ad() && this.isRidingMount()) {
            this.getRidingEntityNN().func_70015_d(8);
        }
        if (((Boolean)ZooConfig.fallenKnightArchersSwitchToMelee.get()).booleanValue() && (!this.isMounted || !((Boolean)ZooConfig.fallKnightMountedArchersMaintainDistance.get()).booleanValue()) && attackTarget != null && this.isRanged() && this.func_70068_e((Entity)attackTarget) < 5.0) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.getSwordForLevel(this.getRandomEquipmentLevel()));
        }
    }

    private boolean isRidingMount() {
        return this.func_184218_aH() && this.getRidingEntityNN().getClass() == EntityFallenMount.class;
    }

    @Nonnull
    public Entity getRidingEntityNN() {
        return (Entity)NullHelper.notnullM((Object)this.func_184187_bx(), (String)"getRidingEntity()");
    }

    protected void func_70623_bb() {
        Entity mount = this.func_184187_bx();
        super.func_70623_bb();
        if (this.field_70128_L && mount != null) {
            mount.func_70106_y();
        }
    }

    private void spawnMount() {
        if (this.func_184218_aH() || !this.spawned) {
            return;
        }
        EntityFallenMount mount = null;
        if (this.field_70146_Z.nextFloat() < ((Float)ZooConfig.fallenKnightChanceMounted.get()).floatValue()) {
            mount = new EntityFallenMount(this.field_70170_p);
            mount.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            DifficultyInstance di = this.field_70170_p.func_175649_E(new BlockPos((Entity)mount));
            mount.func_180482_a(di, null);
            if (!SpawnUtil.isSpaceAvailableForSpawn(this.field_70170_p, (EntityLiving)mount, false)) {
                mount = null;
            }
        }
        if (mount != null) {
            this.func_98053_h(false);
            this.setCanBreakDoors(false);
            this.field_70170_p.func_72838_d((Entity)mount);
            this.func_184220_m((Entity)mount);
        }
    }

    private boolean isRanged() {
        return this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemBow;
    }

    private void addRandomArmor() {
        float occupiedDiffcultyMultiplier = EntityUtil.getDifficultyMultiplierForLocation(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        int equipmentLevel = this.getRandomEquipmentLevel(occupiedDiffcultyMultiplier);
        int armorLevel = equipmentLevel;
        if (armorLevel == 1) {
            ++armorLevel;
        }
        float chancePerPiece = ((Float)(this.isHardDifficulty() ? ZooConfig.fallenKnightChancePerArmorPiece : ZooConfig.fallenKnightChancePerArmorPieceHard).get()).floatValue();
        chancePerPiece *= 1.0f + occupiedDiffcultyMultiplier;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            Item item;
            ItemStack itemStack;
            if (slot == null || !(itemStack = this.func_184582_a(slot)).func_190926_b() || !(this.field_70146_Z.nextFloat() <= chancePerPiece) || (item = EntityLiving.func_184636_a((EntityEquipmentSlot)slot, (int)armorLevel)) == null) continue;
            ItemStack stack = new ItemStack(item);
            if (armorLevel == 0) {
                ((ItemArmor)item).func_82813_b(stack, 0);
            }
            this.func_184201_a(slot, stack);
        }
        if (this.field_70146_Z.nextFloat() >= ((Float)ZooConfig.fallenKnightRangedRatio.get()).floatValue()) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.getSwordForLevel(equipmentLevel));
            if (this.field_70146_Z.nextFloat() < ((Float)ZooConfig.fallenKnightChanceAgentOfShield.get()).floatValue()) {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, this.getShieldForLevel(this.getRandomEquipmentLevel()));
            }
        } else {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.getBowForLevel(equipmentLevel));
        }
    }

    private int getRandomEquipmentLevel() {
        return this.getRandomEquipmentLevel(EntityUtil.getDifficultyMultiplierForLocation(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v));
    }

    private int getRandomEquipmentLevel(float occupiedDiffcultyMultiplier) {
        float chanceImprovedArmor = ((Float)(this.isHardDifficulty() ? ZooConfig.fallenKnightChanceArmorUpgradeHard : ZooConfig.fallenKnightChanceArmorUpgrade).get()).floatValue();
        chanceImprovedArmor *= 1.0f + occupiedDiffcultyMultiplier;
        int armorLevel = this.field_70146_Z.nextInt(2);
        for (int i = 0; i < 2; ++i) {
            if (!(this.field_70146_Z.nextFloat() <= chanceImprovedArmor)) continue;
            ++armorLevel;
        }
        return armorLevel;
    }

    protected boolean isHardDifficulty() {
        return EntityUtil.isHardDifficulty(this.field_70170_p);
    }

    @Nonnull
    private ItemStack getSwordForLevel(int swordLevel) {
        if (swordLevel < 2) {
            swordLevel += this.field_70146_Z.nextInt(this.isHardDifficulty() ? 3 : 2);
            swordLevel = Math.min(swordLevel, 2);
        }
        if (this.field_70146_Z.nextFloat() < 0.8f) {
            switch (swordLevel) {
                case 0: {
                    return new ItemStack(Items.field_151041_m);
                }
                case 1: {
                    return new ItemStack(Items.field_151052_q);
                }
                case 2: {
                    return new ItemStack(Items.field_151040_l);
                }
                case 4: {
                    return new ItemStack(Items.field_151048_u);
                }
            }
            return this.field_70146_Z.nextBoolean() ? new ItemStack(Items.field_151040_l) : new ItemStack(ModObject.itemDarkSteelSword.getItemNN());
        }
        switch (swordLevel) {
            case 0: {
                return new ItemStack(Items.field_151053_p);
            }
            case 1: {
                return new ItemStack(Items.field_151049_t);
            }
            case 2: {
                return new ItemStack(Items.field_151036_c);
            }
            case 4: {
                return new ItemStack(Items.field_151056_x);
            }
        }
        return this.field_70146_Z.nextBoolean() ? new ItemStack(Items.field_151036_c) : new ItemStack(ModObject.itemDarkSteelAxe.getItemNN());
    }

    @Nonnull
    private ItemStack getBowForLevel(int bowLevel) {
        switch (bowLevel) {
            case 0: 
            case 1: {
                return new ItemStack((Item)Items.field_151031_f);
            }
        }
        return new ItemStack(ModObject.itemDarkSteelBow.getItemNN());
    }

    @Nonnull
    private ItemStack getShieldForLevel(int swordLevel) {
        return new ItemStack(Items.field_185159_cQ);
    }

    public IEntityLivingData func_180482_a(@Nonnull DifficultyInstance di, @Nullable IEntityLivingData livingData) {
        this.spawned = true;
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        this.setCombatTaskReal();
        this.addRandomArmor();
        this.func_180483_b(di);
        float f = di.func_180170_c();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        this.setCanBreakDoors(this.field_70146_Z.nextFloat() < f * 0.1f);
        return livingData;
    }

    public void func_70014_b(@Nonnull NBTTagCompound root) {
        super.func_70014_b(root);
        root.func_74757_a("canBreakDoors", this.canBreakDoors);
    }

    public void func_70037_a(@Nonnull NBTTagCompound root) {
        super.func_70037_a(root);
        this.setCanBreakDoors(root.func_74767_n("canBreakDoors"));
        this.setCombatTaskReal();
    }

    private void setCanBreakDoors(boolean val) {
        if (this.canBreakDoors != val) {
            this.canBreakDoors = val;
            if (this.canBreakDoors) {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.breakDoorAI);
            } else {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.breakDoorAI);
            }
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("enderio", NAME);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        EntityLootHelper.dropLoot((EntityLiving)this, (ResourceLocation)this.func_184647_J(), (DamageSource)source);
        this.func_82160_b(wasRecentlyHit, lootingModifier);
    }
}

