/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.entity;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.loot.EntityLootHelper;
import crazypants.enderio.zoo.config.ZooConfig;
import crazypants.enderio.zoo.entity.EntityUtil;
import crazypants.enderio.zoo.entity.IEnderZooEntity;
import crazypants.enderio.zoo.entity.ai.EntityAIAttackOnCollideAggressive;
import crazypants.enderio.zoo.entity.ai.EntityAINearestAttackableTargetBounded;
import crazypants.enderio.zoo.entity.render.RenderDirewolf;
import crazypants.enderio.zoo.sound.SoundRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderiozoo")
public class EntityDireWolf
extends EntityMob
implements IEnderZooEntity.Aggressive {
    @Nonnull
    public static final String NAME = "direwolf";
    public static final int EGG_BG_COL = 0x606060;
    public static final int EGG_FG_COL = 0xA0A0A0;
    @Nonnull
    private static final DataParameter<Boolean> ANGRY_INDEX = EntityDataManager.func_187226_a(EntityDireWolf.class, (DataSerializer)DataSerializers.field_187198_h);
    private EntityLivingBase previsousAttackTarget;
    private static int packHowl = 0;
    private static long lastHowl = 0L;

    @SubscribeEvent
    public static void onEntityRegister(@Nonnull RegistryEvent.Register<EntityEntry> event) {
        IEnderZooEntity.register(event, NAME, EntityDireWolf.class, 0x606060, 0xA0A0A0, IEnderZooEntity.MobID.DWOLF);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPreInit(EnderIOLifecycleEvent.PreInit event) {
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("enderio", NAME));
        RenderingRegistry.registerEntityRenderingHandler(EntityDireWolf.class, (IRenderFactory)RenderDirewolf.FACTORY);
    }

    public EntityDireWolf(World world) {
        super(world);
        this.func_70105_a(0.8f, 1.2f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollideAggressive((EntityLiving)this, 1.1, true).setAttackFrequency(20));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestAttackableTargetBounded<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true).setMaxDistanceToTarget(ZooConfig.wolfAggressionRange));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANGRY_INDEX, (Object)false);
        this.updateAngry();
    }

    public boolean isAngry() {
        return (Boolean)this.field_70180_af.func_187225_a(ANGRY_INDEX);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175710_j(BlockCoord.get((Entity)this)) && super.func_70601_bi();
    }

    protected boolean func_70814_o() {
        return true;
    }

    public int func_70641_bl() {
        return 6;
    }

    private void updateAngry() {
        this.field_70180_af.func_187227_b(ANGRY_INDEX, (Object)(this.func_70638_az() != null ? 1 : 0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.applyAttributes((EntityLivingBase)this, ZooConfig.wolfHealth, ZooConfig.wolfAttackDamage);
    }

    protected void func_180429_a(@Nonnull BlockPos bp, @Nonnull Block p_145780_4_) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        boolean howl;
        if (!this.field_70170_p.field_72995_K) {
            return null;
        }
        if (this.isAngry()) {
            return SoundRegistry.WOLF_GROWL.getSoundEvent();
        }
        if (EntityUtil.isPlayerWithinRange((Entity)this, 12.0)) {
            return SoundRegistry.WOLF_GROWL.getSoundEvent();
        }
        boolean bl = howl = (packHowl > 0 || this.field_70146_Z.nextFloat() <= ((Float)ZooConfig.howlChance.get()).floatValue()) && this.field_70170_p.func_82737_E() > lastHowl + 10L;
        if (howl) {
            if (packHowl <= 0 && this.field_70146_Z.nextFloat() <= ((Float)ZooConfig.howlPackChance.get()).floatValue()) {
                packHowl = (Integer)ZooConfig.howlPackSize.get();
            }
            lastHowl = this.field_70170_p.func_82737_E();
            packHowl = Math.max(packHowl - 1, 0);
            return SoundRegistry.WOLF_HOWL.getSoundEvent();
        }
        return SoundRegistry.WOLF_GROWL.getSoundEvent();
    }

    public void func_184185_a(@Nonnull SoundEvent sound, float volume, float pitch) {
        if (SoundRegistry.WOLF_HOWL.getSoundEvent().equals(sound)) {
            volume *= ((Float)ZooConfig.howlVolume.get()).floatValue();
            pitch *= 0.8f;
        }
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, sound, SoundCategory.NEUTRAL, volume, pitch, true);
    }

    @Nonnull
    protected SoundEvent func_184601_bQ(@Nonnull DamageSource source) {
        return SoundRegistry.WOLF_HURT.getSoundEvent();
    }

    @Nonnull
    protected SoundEvent func_184615_bR() {
        return SoundRegistry.WOLF_DEATH.getSoundEvent();
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("enderio", NAME);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        EntityLootHelper.dropLoot((EntityLiving)this, (ResourceLocation)this.func_184647_J(), (DamageSource)source);
        this.func_82160_b(wasRecentlyHit, lootingModifier);
    }

    public float getTailRotation() {
        if (this.isAngry()) {
            return 1.5707964f;
        }
        return 0.7853982f;
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        double hw = this.field_70130_N / 2.0f;
        double hd = hw * 2.25;
        float f1 = this.field_70131_O;
        this.func_174826_a(new AxisAlignedBB(x - hw, y, z - hd, x + hw, y + (double)f1, z + hd));
    }

    public void func_70636_d() {
        super.func_70636_d();
        EntityLivingBase curTarget = this.func_70638_az();
        if (curTarget != this.previsousAttackTarget) {
            if (curTarget != null) {
                this.doGroupAgro(curTarget);
            }
            this.previsousAttackTarget = this.func_70638_az();
            this.updateAngry();
        }
    }

    private void doGroupAgro(EntityLivingBase curTarget) {
        int range;
        AxisAlignedBB bb;
        List pack;
        if (((Boolean)ZooConfig.packAttackEnabled.get()).booleanValue() && !(pack = this.field_70170_p.func_72872_a(EntityDireWolf.class, bb = new AxisAlignedBB(this.field_70165_t - (double)(range = ((Integer)ZooConfig.packAttackRange.get()).intValue()), this.field_70163_u - (double)range, this.field_70161_v - (double)range, this.field_70165_t + (double)range, this.field_70163_u + (double)range, this.field_70161_v + (double)range))).isEmpty()) {
            for (EntityDireWolf wolf : pack) {
                if (wolf.func_70638_az() != null) continue;
                EntityUtil.cancelCurrentTasks((EntityLiving)wolf);
                wolf.func_70624_b(curTarget);
            }
        }
    }
}

