/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.tile.craft;

import buildcraft.lib.inventory.filter.ArrayStackFilter;
import buildcraft.lib.misc.CraftingUtil;
import buildcraft.lib.misc.InventoryUtil;
import buildcraft.lib.misc.ItemStackKey;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import gnu.trove.map.hash.TObjectIntHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;

public class WorkbenchCrafting
extends InventoryCrafting {
    public static final Container CONTAINER_EVENT_HANDLER = new ContainerNullEventHandler();
    private final TileEntity tile;
    private final ItemHandlerSimple invBlueprint;
    private final ItemHandlerSimple invMaterials;
    private final ItemHandlerSimple invResult;
    private boolean isBlueprintDirty = true;
    private boolean areMaterialsDirty = true;
    private boolean cachedHasRequirements = false;
    @Nullable
    private IRecipe currentRecipe;
    private ItemStack assumedResult = ItemStack.field_190927_a;
    private EnumRecipeType recipeType = null;

    public WorkbenchCrafting(int width, int height, TileBC_Neptune tile, ItemHandlerSimple invBlueprint, ItemHandlerSimple invMaterials, ItemHandlerSimple invResult) {
        super(CONTAINER_EVENT_HANDLER, width, height);
        this.tile = tile;
        this.invBlueprint = invBlueprint;
        if (invBlueprint.getSlots() < this.func_70302_i_()) {
            throw new IllegalArgumentException("Passed blueprint has a smaller size than width * height! ( expected " + this.func_70302_i_() + ", got " + invBlueprint.getSlots() + ")");
        }
        this.invMaterials = invMaterials;
        this.invResult = invResult;
    }

    public ItemStack func_70301_a(int index) {
        return this.isBlueprintDirty ? this.invBlueprint.getStackInSlot(index) : super.func_70301_a(index);
    }

    public ItemStack getAssumedResult() {
        return this.assumedResult;
    }

    public void onInventoryChange(IItemHandler inv) {
        if (inv == this.invBlueprint) {
            this.isBlueprintDirty = true;
        } else if (inv == this.invMaterials) {
            this.areMaterialsDirty = true;
        }
    }

    public boolean tick() {
        if (this.tile.func_145831_w().field_72995_K) {
            throw new IllegalStateException("Never call this on the client side!");
        }
        if (this.isBlueprintDirty) {
            this.currentRecipe = CraftingUtil.findMatchingRecipe(this, this.tile.func_145831_w());
            if (this.currentRecipe == null) {
                this.assumedResult = ItemStack.field_190927_a;
                this.recipeType = null;
            } else {
                this.assumedResult = this.currentRecipe.func_77572_b((InventoryCrafting)this);
                NonNullList ingredients = this.currentRecipe.func_192400_c();
                this.recipeType = ingredients.isEmpty() ? EnumRecipeType.EXACT_STACKS : EnumRecipeType.INGREDIENTS;
            }
            this.isBlueprintDirty = false;
            return true;
        }
        return false;
    }

    public boolean canCraft() {
        if (this.currentRecipe == null || this.isBlueprintDirty) {
            return false;
        }
        if (!this.invResult.canFullyAccept(this.assumedResult)) {
            return false;
        }
        if (this.areMaterialsDirty) {
            this.areMaterialsDirty = false;
            switch (this.recipeType) {
                case INGREDIENTS: 
                case EXACT_STACKS: {
                    this.cachedHasRequirements = this.hasExactStacks();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown recipe type " + (Object)((Object)this.recipeType));
                }
            }
        }
        return this.cachedHasRequirements;
    }

    public boolean craft() throws IllegalStateException {
        if (this.isBlueprintDirty) {
            return false;
        }
        switch (this.recipeType) {
            case INGREDIENTS: 
            case EXACT_STACKS: {
                return this.craftExact();
            }
        }
        throw new IllegalStateException("Unknown recipe type " + (Object)((Object)this.recipeType));
    }

    private boolean hasExactStacks() {
        TObjectIntHashMap required = new TObjectIntHashMap(this.func_70302_i_());
        for (int s = 0; s < this.func_70302_i_(); ++s) {
            ItemStack req = this.invBlueprint.getStackInSlot(s);
            if (req.func_190926_b()) continue;
            int count2 = req.func_190916_E();
            if (count2 != 1) {
                req = req.func_77946_l();
                req.func_190920_e(1);
            }
            ItemStackKey key = new ItemStackKey(req);
            required.adjustOrPutValue((Object)key, count2, count2);
        }
        return required.forEachEntry((stack, count) -> {
            ArrayStackFilter filter = new ArrayStackFilter(stack.baseStack);
            ItemStack inInventory = this.invMaterials.extract(filter, count, count, true);
            return !inInventory.func_190926_b() && inInventory.func_190916_E() == count;
        });
    }

    private boolean craftExact() {
        ItemStack inSlot;
        int s;
        this.clearInventory();
        for (int s2 = 0; s2 < this.func_70302_i_(); ++s2) {
            ItemStack bpt = this.invBlueprint.getStackInSlot(s2);
            if (bpt.func_190926_b()) continue;
            ItemStack stack = this.invMaterials.extract(new ArrayStackFilter(bpt), 1, 1, false);
            if (stack.func_190926_b()) {
                this.clearInventory();
                return false;
            }
            this.func_70299_a(s2, stack);
        }
        if (!this.currentRecipe.func_77569_a((InventoryCrafting)this, this.tile.func_145831_w())) {
            return false;
        }
        ItemStack result = this.currentRecipe.func_77572_b((InventoryCrafting)this);
        if (result.func_190926_b()) {
            this.clearInventory();
            return false;
        }
        ItemStack leftover = this.invResult.insert(result, false, false);
        if (!leftover.func_190926_b()) {
            InventoryUtil.addToBestAcceptor(this.tile.func_145831_w(), this.tile.func_174877_v(), null, leftover);
        }
        NonNullList remainingStacks = this.currentRecipe.func_179532_b((InventoryCrafting)this);
        for (s = 0; s < remainingStacks.size(); ++s) {
            inSlot = this.func_70301_a(s);
            ItemStack remaining = (ItemStack)remainingStacks.get(s);
            if (!inSlot.func_190926_b()) {
                this.func_70298_a(s, 1);
                inSlot = this.func_70301_a(s);
            }
            if (remaining.func_190926_b()) continue;
            if (inSlot.func_190926_b()) {
                this.func_70299_a(s, remaining);
                continue;
            }
            if (ItemStack.func_179545_c((ItemStack)inSlot, (ItemStack)remaining) && ItemStack.func_77970_a((ItemStack)inSlot, (ItemStack)remaining)) {
                remaining.func_190917_f(inSlot.func_190916_E());
                this.func_70299_a(s, remaining);
                continue;
            }
            leftover = this.invMaterials.insert(remaining, false, false);
            if (leftover.func_190926_b()) continue;
            InventoryUtil.addToBestAcceptor(this.tile.func_145831_w(), this.tile.func_174877_v(), null, leftover);
        }
        for (s = 0; s < this.func_70302_i_(); ++s) {
            inSlot = super.func_70301_a(s);
            if (inSlot.func_190926_b()) continue;
            leftover = this.invMaterials.insert(inSlot, false, false);
            this.func_70298_a(s, inSlot.func_190916_E() - (leftover.func_190926_b() ? 0 : leftover.func_190916_E()));
            if (leftover.func_190926_b()) continue;
            InventoryUtil.addToBestAcceptor(this.tile.func_145831_w(), this.tile.func_174877_v(), null, leftover);
        }
        return true;
    }

    private boolean clearInventory() {
        for (int s = 0; s < this.func_70302_i_(); ++s) {
            ItemStack inSlot = super.func_70301_a(s);
            if (inSlot.func_190926_b()) continue;
            ItemStack leftover = this.invMaterials.insert(inSlot, false, false);
            this.func_70298_a(s, inSlot.func_190916_E() - (leftover.func_190926_b() ? 0 : leftover.func_190916_E()));
            if (leftover.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    static class ContainerNullEventHandler
    extends Container {
        ContainerNullEventHandler() {
        }

        public boolean func_75145_c(EntityPlayer playerIn) {
            return false;
        }

        public void func_75130_a(IInventory inventoryIn) {
        }
    }

    static enum EnumRecipeType {
        INGREDIENTS,
        EXACT_STACKS;

    }
}

