/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import javax.annotation.Nonnull;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class VecUtil {
    public static final BlockPos POS_ONE = new BlockPos(1, 1, 1);
    public static final Vec3d VEC_HALF = new Vec3d(0.5, 0.5, 0.5);
    public static final Vec3d VEC_ONE = new Vec3d(1.0, 1.0, 1.0);

    public static Vec3d add(Vec3d a, Vec3i b) {
        return a.func_72441_c((double)b.func_177958_n(), (double)b.func_177956_o(), (double)b.func_177952_p());
    }

    public static Vec3d offset(Vec3d from, EnumFacing direction, double by) {
        return from.func_72441_c((double)direction.func_82601_c() * by, (double)direction.func_96559_d() * by, (double)direction.func_82599_e() * by);
    }

    public static double dot(Vec3d a, Vec3d b) {
        return a.field_72450_a * b.field_72450_a + a.field_72448_b * b.field_72448_b + a.field_72449_c * b.field_72449_c;
    }

    public static Vec3d scale(Vec3d vec, double scale) {
        return vec.func_186678_a(scale);
    }

    public static EnumFacing getFacing(EnumFacing.Axis axis, boolean positive) {
        EnumFacing.AxisDirection dir = positive ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE;
        return EnumFacing.func_181076_a((EnumFacing.AxisDirection)dir, (EnumFacing.Axis)axis);
    }

    public static BlockPos absolute(BlockPos val) {
        return new BlockPos(Math.abs(val.func_177958_n()), Math.abs(val.func_177956_o()), Math.abs(val.func_177952_p()));
    }

    public static Vec3d replaceValue(Vec3d old, EnumFacing.Axis axis, double with) {
        return new Vec3d(axis == EnumFacing.Axis.X ? with : old.field_72450_a, axis == EnumFacing.Axis.Y ? with : old.field_72448_b, axis == EnumFacing.Axis.Z ? with : old.field_72449_c);
    }

    @Nonnull
    public static BlockPos replaceValue(Vec3i old, EnumFacing.Axis axis, int with) {
        return new BlockPos(axis == EnumFacing.Axis.X ? with : old.func_177958_n(), axis == EnumFacing.Axis.Y ? with : old.func_177956_o(), axis == EnumFacing.Axis.Z ? with : old.func_177952_p());
    }

    public static double getValue(Vec3d from, EnumFacing.Axis axis) {
        return axis == EnumFacing.Axis.X ? from.field_72450_a : (axis == EnumFacing.Axis.Y ? from.field_72448_b : from.field_72449_c);
    }

    public static int getValue(Vec3i from, EnumFacing.Axis axis) {
        return axis == EnumFacing.Axis.X ? from.func_177958_n() : (axis == EnumFacing.Axis.Y ? from.func_177956_o() : from.func_177952_p());
    }

    public static double getValue(Vec3d negative, Vec3d positive, EnumFacing face) {
        switch (face) {
            case DOWN: {
                return negative.field_72448_b;
            }
            case UP: {
                return positive.field_72448_b;
            }
            case NORTH: {
                return negative.field_72449_c;
            }
            case SOUTH: {
                return positive.field_72449_c;
            }
            case WEST: {
                return negative.field_72450_a;
            }
            case EAST: {
                return positive.field_72450_a;
            }
        }
        throw new IllegalArgumentException("Unknwon EnumFacing " + face);
    }

    public static int getValue(Vec3i negative, Vec3i positive, EnumFacing face) {
        switch (face) {
            case DOWN: {
                return negative.func_177956_o();
            }
            case UP: {
                return positive.func_177956_o();
            }
            case NORTH: {
                return negative.func_177952_p();
            }
            case SOUTH: {
                return positive.func_177952_p();
            }
            case WEST: {
                return negative.func_177958_n();
            }
            case EAST: {
                return positive.func_177958_n();
            }
        }
        throw new IllegalArgumentException("Unknwon EnumFacing " + face);
    }

    public static Vec3d convertCenter(Vec3i pos) {
        return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static BlockPos convertFloor(Vec3d vec) {
        return new BlockPos(Math.floor(vec.field_72450_a), Math.floor(vec.field_72448_b), Math.floor(vec.field_72449_c));
    }

    public static BlockPos convertCeiling(Vec3d vec) {
        return new BlockPos(Math.ceil(vec.field_72450_a), Math.ceil(vec.field_72448_b), Math.ceil(vec.field_72449_c));
    }

    public static Tuple3f convertFloat(Vec3d vec) {
        return new Vector3f((float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c);
    }

    public static BlockPos min(BlockPos a, BlockPos b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new BlockPos(Math.min(a.func_177958_n(), b.func_177958_n()), Math.min(a.func_177956_o(), b.func_177956_o()), Math.min(a.func_177952_p(), b.func_177952_p()));
    }

    public static BlockPos min(BlockPos a, BlockPos b, BlockPos c) {
        return VecUtil.min(VecUtil.min(a, b), c);
    }

    public static BlockPos min(BlockPos a, BlockPos b, BlockPos c, BlockPos d) {
        return VecUtil.min(VecUtil.min(a, b), VecUtil.min(c, d));
    }

    public static BlockPos max(BlockPos a, BlockPos b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new BlockPos(Math.max(a.func_177958_n(), b.func_177958_n()), Math.max(a.func_177956_o(), b.func_177956_o()), Math.max(a.func_177952_p(), b.func_177952_p()));
    }

    public static BlockPos max(BlockPos a, BlockPos b, BlockPos c) {
        return VecUtil.max(VecUtil.max(a, b), c);
    }

    public static BlockPos max(BlockPos a, BlockPos b, BlockPos c, BlockPos d) {
        return VecUtil.max(VecUtil.max(a, b), VecUtil.max(c, d));
    }

    public static Vec3d min(Vec3d a, Vec3d b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new Vec3d(Math.min(a.field_72450_a, b.field_72450_a), Math.min(a.field_72448_b, b.field_72448_b), Math.min(a.field_72449_c, b.field_72449_c));
    }

    public static Vec3d min(Vec3d a, Vec3d b, Vec3d c) {
        return VecUtil.min(VecUtil.min(a, b), c);
    }

    public static Vec3d min(Vec3d a, Vec3d b, Vec3d c, Vec3d d) {
        return VecUtil.min(VecUtil.min(a, b), VecUtil.min(c, d));
    }

    public static Vec3d max(Vec3d a, Vec3d b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new Vec3d(Math.max(a.field_72450_a, b.field_72450_a), Math.max(a.field_72448_b, b.field_72448_b), Math.max(a.field_72449_c, b.field_72449_c));
    }

    public static Vec3d max(Vec3d a, Vec3d b, Vec3d c) {
        return VecUtil.max(VecUtil.max(a, b), c);
    }

    public static Vec3d max(Vec3d a, Vec3d b, Vec3d c, Vec3d d) {
        return VecUtil.max(VecUtil.max(a, b), VecUtil.max(c, d));
    }
}

