/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class SoundUtil {
    public static void playBlockPlace(World world, BlockPos pos) {
        SoundUtil.playBlockPlace(world, pos, world.func_180495_p(pos));
    }

    public static void playBlockPlace(World world, BlockPos pos, IBlockState state) {
        SoundType soundType = state.func_177230_c().getSoundType(state, world, pos, null);
        float volume = (soundType.func_185843_a() + 1.0f) / 2.0f;
        float pitch = soundType.func_185847_b() * 0.8f;
        world.func_184133_a(null, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, volume, pitch);
    }

    public static void playBlockBreak(World world, BlockPos pos) {
        SoundUtil.playBlockBreak(world, pos, world.func_180495_p(pos));
    }

    public static void playBlockBreak(World world, BlockPos pos, IBlockState state) {
        SoundType soundType = state.func_177230_c().getSoundType(state, world, pos, null);
        float volume = (soundType.func_185843_a() + 1.0f) / 2.0f;
        float pitch = soundType.func_185847_b() * 0.8f;
        world.func_184133_a(null, pos, soundType.func_185845_c(), SoundCategory.BLOCKS, volume, pitch);
    }

    public static void playLeverSwitch(World world, BlockPos pos, boolean isNowOn) {
        float pitch = isNowOn ? 0.6f : 0.5f;
        SoundEvent soundEvent = SoundEvents.field_187750_dc;
        world.func_184133_a(null, pos, soundEvent, SoundCategory.BLOCKS, 0.2f, pitch);
    }

    public static void playChangeColour(World world, BlockPos pos, @Nullable EnumDyeColor colour) {
        SoundType soundType = SoundType.field_185859_l;
        SoundEvent soundEvent = colour == null ? SoundEvents.field_187624_K : SoundEvents.field_187886_fs;
        float volume = (soundType.func_185843_a() + 1.0f) / 2.0f;
        float pitch = soundType.func_185847_b() * 0.8f;
        world.func_184133_a(null, pos, soundEvent, SoundCategory.BLOCKS, volume, pitch);
    }

    public static void playSlideSound(World world, BlockPos pos) {
        SoundUtil.playSlideSound(world, pos, world.func_180495_p(pos));
    }

    public static void playSlideSound(World world, BlockPos pos, EnumActionResult result) {
        SoundUtil.playSlideSound(world, pos, world.func_180495_p(pos), result);
    }

    public static void playSlideSound(World world, BlockPos pos, IBlockState state) {
        SoundUtil.playSlideSound(world, pos, state, EnumActionResult.SUCCESS);
    }

    public static void playSlideSound(World world, BlockPos pos, IBlockState state, EnumActionResult result) {
        if (result == EnumActionResult.PASS) {
            return;
        }
        SoundType soundType = state.func_177230_c().getSoundType(state, world, pos, null);
        SoundEvent event = result == EnumActionResult.SUCCESS ? SoundEvents.field_187712_dQ : SoundEvents.field_187715_dR;
        float volume = (soundType.func_185843_a() + 1.0f) / 2.0f;
        float pitch = soundType.func_185847_b() * 0.8f;
        world.func_184133_a(null, pos, event, SoundCategory.BLOCKS, volume, pitch);
    }

    public static void playBucketEmpty(World world, BlockPos pos, FluidStack moved) {
        SoundEvent sound = moved.getFluid().getEmptySound(moved);
        world.func_184133_a(null, pos, sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    public static void playBucketFill(World world, BlockPos pos, FluidStack moved) {
        SoundEvent sound = moved.getFluid().getFillSound(moved);
        world.func_184133_a(null, pos, sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }
}

